/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.wfr;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tratz.featgen.wfr.AbstractWordFindingRule;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTokensBetweenWordAndPossessor
extends AbstractWordFindingRule {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<Token> getProductions(List<Token> tokenList, Parse parse, int tokIndex) {
        HashSet<Token> results = new HashSet<Token>();
        Token tok = tokenList.get(tokIndex);
        List children = parse.getDependentArcLists()[tok.getIndex()];
        if (children != null) {
            for (Arc childArc : children) {
                int last;
                int init2;
                if (!childArc.getDependency().equals("poss")) continue;
                Token possessor = childArc.getChild();
                int possessorIndex = possessor.getIndex();
                if (possessorIndex < tokIndex) {
                    init2 = possessorIndex;
                    last = tok.getIndex() - 1;
                } else {
                    init2 = tok.getIndex();
                    last = possessorIndex - 1;
                }
                for (int i = init2; i < last; ++i) {
                    results.add(tokenList.get(i));
                }
            }
        }
        return results;
    }
}

