/*
 * Decompiled with CFR 0.152.
 */
package tratz.cmdline;

import java.util.List;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParsingException;
import tratz.cmdline.ParsedCommandLine;

public class CommandLineOptionsParser {
    public ParsedCommandLine parseOptions(CommandLineOptions options, String[] args) throws CommandLineOptionsParsingException {
        ParsedCommandLine commandLine = new ParsedCommandLine();
        List<CommandLineOptions.Option> optionsList = options.getOptions();
        for (int i = 0; i < args.length; i += 2) {
            String argumentIdentifier = args[i];
            if (!argumentIdentifier.startsWith("-") || argumentIdentifier.length() <= 1) {
                throw new CommandLineOptionsParsingException("unexpected argument name: " + argumentIdentifier);
            }
            String argIdName = argumentIdentifier.substring(1);
            boolean matched = false;
            for (CommandLineOptions.Option opt : optionsList) {
                if (!opt.getName().equals(argIdName)) continue;
                matched = true;
                commandLine.setArgumentValue(argIdName, args[i + 1]);
            }
            if (matched) continue;
            throw new CommandLineOptionsParsingException("unexpected argument name: " + argumentIdentifier + "\n" + options.getArgumentsDescriptionString());
        }
        return commandLine;
    }
}

