/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.File;
import java.io.IOException;
import opennlp.maxent.io.GISModelReader;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelReader;
import opennlp.model.DataReader;
import opennlp.model.GenericModelWriter;
import opennlp.perceptron.PerceptronModelReader;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File file) throws IOException {
        super(file);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public void checkModelType() throws IOException {
        String string = this.readUTF();
        if (string.equals("Perceptron")) {
            this.delegateModelReader = new PerceptronModelReader(this.dataReader);
        } else if (string.equals("GIS")) {
            this.delegateModelReader = new GISModelReader(this.dataReader);
        } else {
            throw new IOException("Unknown model format: " + string);
        }
    }

    public AbstractModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }

    public static void main(String[] stringArray) throws IOException {
        AbstractModel abstractModel = new GenericModelReader(new File(stringArray[0])).getModel();
        new GenericModelWriter(abstractModel, new File(stringArray[1])).persist();
    }
}

