/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file_manager;

import java.io.IOException;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.RandomAccessDictionaryFile;
import net.didion.jwnl.dictionary.file_manager.FileManager;
import net.didion.jwnl.util.factory.Param;

public class FileManagerImpl
implements FileManager {
    public static final String FILE_TYPE = "file_type";
    public static final String PATH = "dictionary_path";
    private DictionaryCatalogSet _files;
    static /* synthetic */ Class class$net$didion$jwnl$dictionary$file$DictionaryFile;

    public FileManagerImpl() {
    }

    public FileManagerImpl(String string, Class clazz) throws IOException {
        this.checkFileType(clazz);
        this._files = new DictionaryCatalogSet(string, clazz);
        this._files.open();
    }

    public Object create(Map map) throws JWNLException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(((Param)map.get(FILE_TYPE)).getValue());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_002", classNotFoundException);
        }
        this.checkFileType(clazz);
        String string = ((Param)map.get(PATH)).getValue();
        try {
            return new FileManagerImpl(string, clazz);
        }
        catch (IOException iOException) {
            throw new JWNLException("DICTIONARY_EXCEPTION_016", clazz, (Throwable)iOException);
        }
    }

    private void checkFileType(Class clazz) {
        if (!(class$net$didion$jwnl$dictionary$file$DictionaryFile == null ? (class$net$didion$jwnl$dictionary$file$DictionaryFile = FileManagerImpl.class$("net.didion.jwnl.dictionary.file.DictionaryFile")) : class$net$didion$jwnl$dictionary$file$DictionaryFile).isAssignableFrom(clazz)) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_003", clazz);
        }
    }

    public void close() {
        this._files.close();
    }

    public DictionaryFile getFile(POS pOS, DictionaryFileType dictionaryFileType) {
        return this._files.getDictionaryFile(pOS, dictionaryFileType);
    }

    private void skipLine(RandomAccessDictionaryFile randomAccessDictionaryFile) throws IOException {
        int n;
        while ((n = randomAccessDictionaryFile.read()) != -1 && n != 10 && n != 13) {
        }
        n = randomAccessDictionaryFile.read();
        if (n != 10 && n != 13) {
            randomAccessDictionaryFile.seek(randomAccessDictionaryFile.getFilePointer() - 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLineAt(POS pOS, DictionaryFileType dictionaryFileType, long l) throws IOException {
        RandomAccessDictionaryFile randomAccessDictionaryFile;
        RandomAccessDictionaryFile randomAccessDictionaryFile2 = randomAccessDictionaryFile = (RandomAccessDictionaryFile)this.getFile(pOS, dictionaryFileType);
        synchronized (randomAccessDictionaryFile2) {
            randomAccessDictionaryFile.seek(l);
            String string = randomAccessDictionaryFile.readLine();
            long l2 = randomAccessDictionaryFile.getFilePointer();
            if (string == null) {
                l2 = -1L;
            }
            randomAccessDictionaryFile.setNextLineOffset(l, l2);
            return string;
        }
    }

    private String readLineWord(RandomAccessDictionaryFile randomAccessDictionaryFile) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = randomAccessDictionaryFile.read()) != -1 && n != 10 && n != 13 && n != 32) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextLinePointer(POS pOS, DictionaryFileType dictionaryFileType, long l) throws IOException {
        RandomAccessDictionaryFile randomAccessDictionaryFile;
        RandomAccessDictionaryFile randomAccessDictionaryFile2 = randomAccessDictionaryFile = (RandomAccessDictionaryFile)this.getFile(pOS, dictionaryFileType);
        synchronized (randomAccessDictionaryFile2) {
            if (randomAccessDictionaryFile.isPreviousLineOffset(l)) {
                return randomAccessDictionaryFile.getNextLineOffset();
            }
            randomAccessDictionaryFile.seek(l);
            this.skipLine(randomAccessDictionaryFile);
            return randomAccessDictionaryFile.getFilePointer();
        }
    }

    public long getMatchingLinePointer(POS pOS, DictionaryFileType dictionaryFileType, long l, String string) throws IOException {
        RandomAccessDictionaryFile randomAccessDictionaryFile = (RandomAccessDictionaryFile)this.getFile(pOS, dictionaryFileType);
        if (randomAccessDictionaryFile == null || randomAccessDictionaryFile.length() == 0L) {
            return -1L;
        }
        RandomAccessDictionaryFile randomAccessDictionaryFile2 = randomAccessDictionaryFile;
        synchronized (randomAccessDictionaryFile2) {
            randomAccessDictionaryFile.seek(l);
            while (true) {
                String string2 = this.readLineWord(randomAccessDictionaryFile);
                long l2 = randomAccessDictionaryFile.getFilePointer();
                if (string2 == null) {
                    return -1L;
                }
                randomAccessDictionaryFile.setNextLineOffset(l, l2);
                if (string2.indexOf(string) >= 0) {
                    return l;
                }
                l = l2;
            }
        }
    }

    public long getIndexedLinePointer(POS pOS, DictionaryFileType dictionaryFileType, String string) throws IOException {
        RandomAccessDictionaryFile randomAccessDictionaryFile = (RandomAccessDictionaryFile)this.getFile(pOS, dictionaryFileType);
        if (randomAccessDictionaryFile == null || randomAccessDictionaryFile.length() == 0L) {
            return -1L;
        }
        RandomAccessDictionaryFile randomAccessDictionaryFile2 = randomAccessDictionaryFile;
        synchronized (randomAccessDictionaryFile2) {
            long l = 0L;
            long l2 = randomAccessDictionaryFile.length();
            long l3 = l;
            while (true) {
                String string2;
                long l4 = (l + l2) / 2L;
                randomAccessDictionaryFile.seek(l4);
                randomAccessDictionaryFile.readLine();
                l3 = randomAccessDictionaryFile.getFilePointer();
                if (l2 == l3) {
                    randomAccessDictionaryFile.seek(l);
                    l3 = randomAccessDictionaryFile.getFilePointer();
                    while (l3 != l2) {
                        string2 = this.readLineWord(randomAccessDictionaryFile);
                        if (string2.equals(string)) {
                            return l3;
                        }
                        randomAccessDictionaryFile.readLine();
                        l3 = randomAccessDictionaryFile.getFilePointer();
                    }
                    return -1L;
                }
                string2 = this.readLineWord(randomAccessDictionaryFile);
                int n = string2.compareTo(string);
                if (n == 0) {
                    return l3;
                }
                if (n > 0) {
                    l2 = l3;
                    continue;
                }
                l = l3;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

