/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.ConstantMatrix;
import edu.umass.cs.mallet.base.types.Matrix;
import edu.umass.cs.mallet.base.util.Maths;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class DenseMatrix
implements Matrix,
Serializable {
    double[] values;
    protected boolean hasInfinite;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public abstract int getNumDimensions();

    public abstract int getDimensions(int[] var1);

    public abstract double value(int[] var1);

    public abstract void setValue(int[] var1, double var2);

    public abstract ConstantMatrix cloneMatrix();

    public abstract int singleIndex(int[] var1);

    public abstract void singleToIndices(int var1, int[] var2);

    public double singleValue(int i) {
        return this.values[i];
    }

    public void setSingleValue(int i, double value) {
        this.values[i] = value;
    }

    public void incrementSingleValue(int i, double delta) {
        int n = i;
        this.values[n] = this.values[n] + delta;
    }

    public void setValueAtLocation(int loc, double value) {
        this.setSingleValue(loc, value);
    }

    public int singleSize() {
        return this.values.length;
    }

    public int numLocations() {
        return this.values.length;
    }

    public int location(int index) {
        return index;
    }

    public double valueAtLocation(int location) {
        return this.values[location];
    }

    public int indexAtLocation(int location) {
        return location;
    }

    public void setAll(double v) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    public void set(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            System.arraycopy(((DenseMatrix)m).values, 0, this.values, 0, this.values.length);
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i);
                --i;
            }
        }
    }

    public void setWithAddend(ConstantMatrix m, double addend) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = ((DenseMatrix)m).values[i] + addend;
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) + addend;
                --i;
            }
        }
    }

    public void setWithFactor(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = ((DenseMatrix)m).values[i] * factor;
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) * factor;
                --i;
            }
        }
    }

    public void plusEquals(double v) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] + v;
        }
    }

    public void plusEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                    } else {
                        int n = i;
                        this.values[n] = this.values[n] + newValue;
                    }
                } else {
                    int n = i;
                    this.values[n] = this.values[n] + m.valueAtLocation(i);
                }
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                    } else {
                        int n = m.indexAtLocation(i);
                        this.values[n] = this.values[n] + newValue;
                    }
                } else {
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + m.valueAtLocation(i);
                }
                --i;
            }
        }
    }

    public void plusEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                    } else {
                        int n = i;
                        this.values[n] = this.values[n] + newValue;
                    }
                } else {
                    int n = i;
                    this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
                }
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                    } else {
                        int n = m.indexAtLocation(i);
                        this.values[n] = this.values[n] + newValue;
                    }
                } else {
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
                }
                --i;
            }
        }
    }

    public void equalsPlus(double factor, ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                double rhs;
                double lhs;
                this.values[i] = Double.isInfinite(this.values[i]) && Double.isInfinite(((DenseMatrix)m).values[i]) ? ((lhs = factor * this.values[i]) * (rhs = ((DenseMatrix)m).values[i]) < 0.0 ? 0.0 : lhs + rhs) : factor * this.values[i] + ((DenseMatrix)m).values[i];
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                double rhs;
                double lhs;
                this.values[m.indexAtLocation((int)i)] = Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i]) ? ((lhs = factor * this.values[m.indexAtLocation(i)]) * (rhs = m.valueAtLocation(i)) < 0.0 ? 0.0 : lhs + rhs) : factor * this.values[m.indexAtLocation(i)] + m.valueAtLocation(i);
                --i;
            }
        }
    }

    public void timesEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * factor;
        }
    }

    public void elementwiseTimesEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                int n = i;
                this.values[n] = this.values[n] * ((DenseMatrix)m).values[i];
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * m.valueAtLocation(i);
                --i;
            }
        }
    }

    public void elementwiseTimesEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                int n = i;
                this.values[n] = this.values[n] * (((DenseMatrix)m).values[i] * factor);
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * (m.valueAtLocation(i) * factor);
                --i;
            }
        }
    }

    public void divideEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / factor;
        }
    }

    public void elementwiseDivideEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                int n = i;
                this.values[n] = this.values[n] / ((DenseMatrix)m).values[i];
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / m.valueAtLocation(i);
                --i;
            }
        }
    }

    public void elementwiseDivideEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                int n = i;
                this.values[n] = this.values[n] / (((DenseMatrix)m).values[i] * factor);
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / (m.valueAtLocation(i) * factor);
                --i;
            }
        }
    }

    public double dotProduct(ConstantMatrix m) {
        double ret = 0.0;
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            int i = 0;
            while (i < this.values.length) {
                ret += this.values[i] * ((DenseMatrix)m).values[i];
                ++i;
            }
        } else {
            int i = m.numLocations() - 1;
            while (i >= 0) {
                if (m.indexAtLocation(i) < this.values.length) {
                    ret += this.values[m.indexAtLocation(i)] * m.valueAtLocation(i);
                }
                --i;
            }
        }
        return ret;
    }

    public double absNorm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.values.length) {
            ret += Math.abs(this.values[i]);
            ++i;
        }
        return ret;
    }

    public double oneNorm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.values.length) {
            ret += this.values[i];
            ++i;
        }
        return ret;
    }

    public double twoNorm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.values.length) {
            ret += this.values[i] * this.values[i];
            ++i;
        }
        return Math.sqrt(ret);
    }

    public double infinityNorm() {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.values.length) {
            if (Math.abs(this.values[i]) > max) {
                max = Math.abs(this.values[i]);
            }
            ++i;
        }
        return max;
    }

    public double oneNormalize() {
        double norm = this.oneNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public double twoNormalize() {
        double norm = this.twoNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public double absNormalize() {
        double norm = this.absNorm();
        if (norm > 0.0) {
            int i = 0;
            while (i < this.values.length) {
                int n = i++;
                this.values[n] = this.values[n] / norm;
            }
        }
        return norm;
    }

    public double infinityNormalize() {
        double norm = this.infinityNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public void print() {
        int i = 0;
        while (i < this.values.length) {
            System.out.println("DenseMatrix[" + i + "] = " + this.values[i]);
            ++i;
        }
    }

    public boolean isNaN() {
        int i = 0;
        while (i < this.values.length) {
            if (Double.isNaN(this.values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void substitute(double oldValue, double newValue) {
        int i = this.values.length - 1;
        while (i >= 0) {
            if (this.values[i] == oldValue) {
                this.values[i] = newValue;
            }
            --i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        if (this.values != null) {
            int size = this.values.length;
            out.writeInt(size);
            int i = 0;
            while (i < size) {
                out.writeDouble(this.values[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.hasInfinite = false;
        int version = in.readInt();
        int size = in.readInt();
        if (size != -1) {
            this.values = new double[size];
            int i = 0;
            while (i < size) {
                this.values[i] = in.readDouble();
                if (Double.isInfinite(this.values[i])) {
                    this.hasInfinite = true;
                }
                ++i;
            }
        } else {
            this.values = null;
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend) {
        assert (accumulator.length == addend.length);
        int i = 0;
        while (i < addend.length) {
            int n = i;
            accumulator[n] = accumulator[n] + addend[i];
            ++i;
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend, double factor) {
        assert (accumulator.length == addend.length);
        int i = 0;
        while (i < addend.length) {
            int n = i;
            accumulator[n] = accumulator[n] + factor * addend[i];
            ++i;
        }
    }

    public static void timesEquals(double[] accumulator, double[] product) {
        assert (accumulator.length == product.length);
        int i = 0;
        while (i < product.length) {
            int n = i;
            accumulator[n] = accumulator[n] * product[i];
            ++i;
        }
    }

    public static double infinityNorm(double[] vector) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < vector.length) {
            if (Math.abs(vector[i]) > max) {
                max = Math.abs(vector[i]);
            }
            ++i;
        }
        return max;
    }

    public boolean almostEquals(ConstantMatrix m2) {
        if (this.getNumDimensions() != m2.getNumDimensions()) {
            return false;
        }
        if (this.numLocations() != m2.numLocations()) {
            return false;
        }
        int[] dims1 = new int[this.getNumDimensions()];
        int[] dims2 = new int[this.getNumDimensions()];
        this.getDimensions(dims1);
        m2.getDimensions(dims2);
        int i = 0;
        while (i < dims1.length) {
            if (dims1[i] != dims2[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.numLocations()) {
            if (!Maths.almostEquals(this.valueAtLocation(i), m2.valueAtLocation(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

