/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.Lisp.FeatureSet;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Span;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
implements Serializable {
    StringBuffer text;
    private Hashtable annotationsByStart;
    private Hashtable annotationsByEnd;
    private Hashtable annotationsByType;
    private int nextAnnotationId;
    private Object currentHypothesis = null;
    private Set activeHypotheses = null;
    private int sgmlWrapMargin = 80;
    private int sgmlIndent = 0;
    boolean strictNesting = false;

    public Document() {
        this.text = new StringBuffer();
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
    }

    public Document(String string) {
        this.text = new StringBuffer(string);
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
    }

    public Document(Document document) {
        this.text = new StringBuffer(document.text);
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
        String[] stringArray = document.getAnnotationTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<Annotation> vector = document.annotationsOfType(stringArray[i]);
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = vector.get(j);
                FeatureSet featureSet = null;
                if (annotation.attributes != null) {
                    featureSet = new FeatureSet(annotation.attributes);
                }
                this.annotate(stringArray[i], annotation.span(), featureSet);
            }
        }
    }

    public void clear() {
        this.text.setLength(0);
        this.annotationsByStart.clear();
        this.annotationsByEnd.clear();
        this.annotationsByType.clear();
        this.nextAnnotationId = 0;
    }

    public void setText(String string) {
        this.text = new StringBuffer(string);
    }

    public String text() {
        return this.text.toString();
    }

    public String text(Span span) {
        return this.text.substring(span.start(), span.end());
    }

    public String text(Annotation annotation) {
        return this.text(annotation.span());
    }

    public String normalizedText(Span span) {
        return Resolve.normalizeName(this.text.substring(span.start(), span.end()));
    }

    public String normalizedText(Annotation annotation) {
        return this.normalizedText(annotation.span());
    }

    public StringBuffer append(String string) {
        return this.text.append(string);
    }

    public StringBuffer append(char c) {
        return this.text.append(c);
    }

    public int length() {
        return this.text.length();
    }

    public Span fullSpan() {
        return new Span(0, this.text.length());
    }

    public char charAt(int n) {
        return this.text.charAt(n);
    }

    public void setCharAt(int n, char c) {
        this.text.setCharAt(n, c);
    }

    public void clearAnnotations() {
        this.annotationsByStart.clear();
        this.annotationsByEnd.clear();
        this.annotationsByType.clear();
    }

    public Annotation addAnnotation(Annotation annotation) {
        Integer n = new Integer(annotation.span.start);
        if (!this.annotationsByStart.containsKey(n)) {
            this.annotationsByStart.put(n, new Vector());
        }
        Vector vector = (Vector)this.annotationsByStart.get(n);
        vector.add(annotation);
        Integer n2 = new Integer(annotation.span.end);
        if (!this.annotationsByEnd.containsKey(n2)) {
            this.annotationsByEnd.put(n2, new Vector());
        }
        Vector vector2 = (Vector)this.annotationsByEnd.get(n2);
        vector2.add(annotation);
        String string = annotation.type;
        if (!this.annotationsByType.containsKey(string)) {
            this.annotationsByType.put(string, new Vector());
        }
        Vector vector3 = (Vector)this.annotationsByType.get(string);
        vector3.add(annotation);
        if (this.currentHypothesis != null) {
            annotation.put("hypo", this.currentHypothesis);
        }
        Span span = annotation.span();
        span.setDocument(this);
        return annotation;
    }

    public Annotation annotate(String string, Span span, FeatureSet featureSet) {
        return this.addAnnotation(new Annotation(string, span, featureSet));
    }

    public void removeAnnotation(Annotation annotation) {
        String string;
        Vector vector;
        Integer n;
        Vector vector2;
        Integer n2 = new Integer(annotation.span.start);
        Vector vector3 = (Vector)this.annotationsByStart.get(n2);
        if (vector3 != null) {
            vector3.remove(annotation);
        }
        if ((vector2 = (Vector)this.annotationsByEnd.get(n = new Integer(annotation.span.end))) != null) {
            vector2.remove(annotation);
        }
        if ((vector = (Vector)this.annotationsByType.get(string = annotation.type)) != null) {
            vector.remove(annotation);
        }
    }

    public void removeAnnotationsOfType(String string) {
        Vector<Annotation> vector = this.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            this.removeAnnotation(annotation);
        }
    }

    public Vector<Annotation> annotationsAt(int n) {
        Integer n2 = new Integer(n);
        Vector vector = (Vector)this.annotationsByStart.get(n2);
        if (vector == null) {
            return null;
        }
        return this.activeAnnotations(vector);
    }

    public Vector<Annotation> annotationsAt(int n, String string) {
        Vector<Annotation> vector = this.annotationsAt(n);
        if (vector == null) {
            return null;
        }
        Vector<Annotation> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            if (!annotation.type().equals(string)) continue;
            if (vector2 == null) {
                vector2 = new Vector<Annotation>();
            }
            vector2.addElement(annotation);
        }
        return vector2;
    }

    public Vector<Annotation> annotationsAt(int n, String[] stringArray) {
        Vector<Annotation> vector = this.annotationsAt(n);
        if (vector == null) {
            return null;
        }
        Vector<Annotation> vector2 = null;
        for (Annotation annotation : vector) {
            for (String string : stringArray) {
                if (!annotation.type().equals(string)) continue;
                if (vector2 == null) {
                    vector2 = new Vector<Annotation>();
                }
                vector2.addElement(annotation);
            }
        }
        return vector2;
    }

    public Vector<Annotation> annotationsEndingAt(int n) {
        Integer n2 = new Integer(n);
        Vector vector = (Vector)this.annotationsByEnd.get(n2);
        if (vector == null) {
            return null;
        }
        return this.activeAnnotations(vector);
    }

    public Vector<Annotation> annotationsEndingAt(int n, String string) {
        Vector<Annotation> vector = this.annotationsEndingAt(n);
        if (vector == null) {
            return null;
        }
        Vector<Annotation> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            if (!annotation.type().equals(string)) continue;
            if (vector2 == null) {
                vector2 = new Vector<Annotation>();
            }
            vector2.addElement(annotation);
        }
        return vector2;
    }

    public Annotation tokenAt(int n) {
        Vector<Annotation> vector = this.annotationsAt(n);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            if (!annotation.type().equals("token")) continue;
            return annotation;
        }
        return null;
    }

    public Annotation tokenEndingAt(int n) {
        Vector<Annotation> vector = this.annotationsEndingAt(n);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            if (!annotation.type().equals("token")) continue;
            return annotation;
        }
        return null;
    }

    public Vector<Annotation> annotationsOfType(String string) {
        Vector vector = (Vector)this.annotationsByType.get(string);
        return this.activeAnnotations(vector);
    }

    public Vector<Annotation> annotationsOfType(String string, Span span) {
        Vector<Annotation> vector = this.annotationsOfType(string);
        if (vector == null) {
            return null;
        }
        if (span == null) {
            return vector;
        }
        Vector<Annotation> vector2 = new Vector<Annotation>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            if (!annotation.span().within(span)) continue;
            vector2.add(annotation);
        }
        if (vector2.size() > 0) {
            return vector2;
        }
        return null;
    }

    public void setCurrentHypothesis(Object object) {
        this.currentHypothesis = object;
    }

    public void setActiveHypotheses(Set set) {
        this.activeHypotheses = set;
    }

    private Vector<Annotation> activeAnnotations(Vector vector) {
        if (vector == null) {
            return null;
        }
        if (this.activeHypotheses == null) {
            return (Vector)vector.clone();
        }
        Vector<Annotation> vector2 = new Vector<Annotation>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Object object = annotation.get("hypo");
            if (object != null && !this.activeHypotheses.contains(object)) continue;
            vector2.add(annotation);
        }
        return vector2;
    }

    public String[] getAnnotationTypes() {
        return this.annotationsByType.keySet().toArray(new String[0]);
    }

    public void annotateWithTag(String string, int n, int n2) {
        String string2 = "/" + string;
        int n3 = 0;
        int n4 = 0;
        FeatureSet featureSet = new FeatureSet();
        StringBuffer stringBuffer = null;
        boolean bl = false;
        for (int i = n; i < n2 && i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '<') {
                bl = true;
                stringBuffer = new StringBuffer();
                n4 = i - 1;
                continue;
            }
            if (!bl) continue;
            if (c == '>') {
                bl = false;
                String string3 = stringBuffer.toString();
                if (string3.equalsIgnoreCase(string)) {
                    n3 = i + 1;
                    continue;
                }
                if (!string3.equalsIgnoreCase(string2)) continue;
                if (n3 != 0 && n4 != 0 && n3 < n4) {
                    this.annotate(string, new Span(n3, n4), featureSet);
                }
                n3 = 0;
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public void annotateWithTag(String string) {
        this.annotateWithTag(string, 0, this.length());
    }

    public int getNextAnnotationId() {
        return this.nextAnnotationId++;
    }

    public void setSGMLwrapMargin(int n) {
        this.sgmlWrapMargin = n;
    }

    public void setSGMLindent(int n) {
        this.sgmlIndent = n;
    }

    public StringBuffer writeSGML(String string) {
        if (string == null) {
            return this.writeSGML(null, 0, this.text.length());
        }
        return this.writeSGML(new String[]{string}, 0, this.text.length());
    }

    public StringBuffer writeSGML(String string, Span span) {
        if (string == null) {
            return this.writeSGML(null, span.start(), span.end());
        }
        return this.writeSGML(new String[]{string}, span.start(), span.end());
    }

    public StringBuffer writeSGML(String[] stringArray, int n, int n2) {
        this.prepareToWriteSGML(stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        Stack<Annotation> stack = new Stack<Annotation>();
        for (int i = n; i < n2; ++i) {
            Object object;
            Vector<Annotation> vector = stringArray == null ? this.annotationsAt(i) : this.annotationsAt(i, stringArray);
            if (vector != null) {
                Object object2;
                int n4;
                Annotation.sort(vector);
                if (this.strictNesting) {
                    int n5;
                    int n6;
                    if (!stack.empty() && (n6 = vector.get(0).span().end()) > (n5 = ((Annotation)stack.peek()).span().end())) {
                        System.err.println("writeSGML:  annotations not nested.");
                        System.err.println(vector.get(0) + " crosses " + stack.peek());
                    }
                } else {
                    block1: for (Annotation annotation : vector) {
                        for (n4 = stack.size() - 1; n4 >= 0; --n4) {
                            object2 = (Annotation)stack.get(n4);
                            if (!annotation.type().equals(((Annotation)object2).type)) continue;
                            if (annotation.span().end() <= ((Annotation)object2).span().end()) continue block1;
                            System.err.println("writeSGML:  annotations of same type not nested.");
                            System.err.println(object2 + " crosses " + annotation);
                            continue block1;
                        }
                    }
                }
                for (Annotation annotation : vector) {
                    n4 = annotation.span().end();
                    if (n4 > n2) {
                        System.err.println("writeSGML:  annotation extending past end of span was suppressed");
                        System.err.println("            " + annotation);
                        continue;
                    }
                    object2 = annotation.toSGMLString();
                    if (this.sgmlIndent > 0) {
                        if (stack.empty()) {
                            n3 += ((String)object2).length();
                        } else {
                            object2 = "<\n" + this.blankString(stack.size() * this.sgmlIndent) + ((String)object2).substring(1);
                            n3 = ((String)object2).length() - 2;
                        }
                    } else if (this.sgmlWrapMargin > 0 && n3 + ((String)object2).length() > this.sgmlWrapMargin) {
                        object2 = ((String)object2).substring(0, ((String)object2).length() - 1) + "\n>";
                        n3 = 1;
                    } else {
                        n3 += ((String)object2).length();
                    }
                    stringBuffer.append((String)object2);
                    stack.push(annotation);
                }
                Annotation.sort(stack);
            }
            while (!stack.empty() && ((Annotation)stack.peek()).span().end() == i) {
                object = ((Annotation)stack.peek()).type();
                String string = "</" + (String)object + ">";
                stringBuffer.append(string);
                stack.pop();
            }
            stringBuffer.append(this.text.charAt(i));
            n3 = this.text.charAt(i) == '\n' ? 0 : ++n3;
            while (!stack.empty() && ((Annotation)stack.peek()).span().end() == 1 + i) {
                object = ((Annotation)stack.peek()).type();
                if (this.sgmlIndent > 0) {
                    stringBuffer.append("<\n" + this.blankString((stack.size() - 1) * this.sgmlIndent) + "/" + (String)object + ">");
                    n3 = ((String)object).length() + 1;
                } else {
                    stringBuffer.append("</" + (String)object + ">");
                    n3 += ((String)object).length() + 3;
                }
                stack.pop();
            }
        }
        while (!stack.empty()) {
            System.err.println("Internal writeSGML error:  didn't close annotation " + stack.pop());
        }
        return stringBuffer;
    }

    private void prepareToWriteSGML(String[] stringArray) {
        for (int i = 0; i < this.text.length(); ++i) {
            Vector<Annotation> vector = stringArray == null ? this.annotationsAt(i) : this.annotationsAt(i, stringArray);
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = vector.get(j);
                annotation.prepareToMakeString(1);
            }
        }
    }

    private String blankString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void stretch(Annotation annotation) {
        int n;
        this.removeAnnotation(annotation);
        Span span = annotation.span();
        for (n = span.end(); n < this.text.length() && this.annotationsByStart.get(n) == null && Character.isWhitespace(this.charAt(n)); ++n) {
        }
        span.setEnd(n);
        this.addAnnotation(annotation);
    }

    public void stretch(String string) {
        Vector<Annotation> vector = this.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            this.stretch(annotation);
        }
    }

    public void stretchAll() {
        String[] stringArray = this.getAnnotationTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.stretch(stringArray[i]);
        }
    }

    public void shrink(Annotation annotation) {
        int n;
        this.removeAnnotation(annotation);
        Span span = annotation.span();
        int n2 = span.start();
        for (n = span.end(); n > n2 && Character.isWhitespace(this.charAt(n - 1)); --n) {
        }
        span.setEnd(n);
        this.addAnnotation(annotation);
    }

    public void shrink(String string) {
        Vector<Annotation> vector = this.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            this.shrink(annotation);
        }
    }

    public void shrinkAll() {
        String[] stringArray = this.getAnnotationTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.shrink(stringArray[i]);
        }
    }
}

