/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import AceJet.Ace;
import AceJet.Gazetteer;
import Jet.Control;
import Jet.JetTest;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Sparkle {
    static ExternalDocument doc;
    static String currentDoc;
    static final String sourceType = "text";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/Sparkle docs.txt";
    static final String keyFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parse key.log";
    public static String[] relations;
    static int correct;
    static int spurious;
    static int missing;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace parser.properties");
        Ace.gazetteer = new Gazetteer();
        Pat.trace = false;
        Resolve.trace = false;
        HashMap hashMap = Sparkle.readKey(keyFile);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            doc = new ExternalDocument("sgml", "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training/nwire/" + currentDoc + ".sgm");
            doc.open();
            Control.processDocument(doc, null, n < 3, 1);
            ArrayList arrayList = Sparkle.extractDependencies(doc);
            ArrayList arrayList2 = (ArrayList)hashMap.get(currentDoc);
            Sparkle.score(arrayList, arrayList2);
            if (n < 3) continue;
            break;
        }
        System.out.print(correct + " triples correct, " + spurious + " spurious, ");
        System.out.println(missing + " missing.");
    }

    private static ArrayList extractDependencies(Document document) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            int n = annotation.span().start();
            int n2 = annotation.span().end();
            for (int j = n; j < n2; ++j) {
                Vector<Annotation> vector2 = document.annotationsAt(j, "constit");
                if (vector2 == null) continue;
                for (int k = 0; k < vector2.size(); ++k) {
                    Annotation annotation2 = vector2.elementAt(k);
                    for (int i2 = 0; i2 < relations.length; ++i2) {
                        String string = relations[i2];
                        if (annotation2.get(string) == null) continue;
                        Annotation annotation3 = (Annotation)annotation2.get(string);
                        arrayList.add(Sparkle.buildQuad(i + 1, annotation2, string, annotation3));
                    }
                }
            }
        }
        return arrayList;
    }

    private static String buildQuad(int n, Annotation annotation, String string, Annotation annotation2) {
        String string2 = SynFun.getNameOrHead(doc, annotation);
        String string3 = SynFun.getNameOrHead(doc, annotation2);
        return n + "|" + string2 + "|" + string + "|" + string3;
    }

    private static HashMap readKey(String string) throws IOException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        String string3 = "";
        while ((string2 = lineNumberReader.readLine()) != null) {
            int n = string2.indexOf(35);
            if (n >= 0) {
                string2 = string2.substring(0, n).trim();
            }
            if (string2.trim().length() == 0) continue;
            if (string2.length() >= 5 && string2.substring(0, 5).equals("docid")) {
                string3 = string2.substring(5).trim();
                continue;
            }
            if (string3 == "") {
                System.out.println("No docid specified, line ignored");
                continue;
            }
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string3);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
            hashMap.put(string3, arrayList);
        }
        return hashMap;
    }

    private static void score(ArrayList arrayList, ArrayList arrayList2) {
        String string;
        int n;
        if (arrayList2 == null) {
            System.out.println("No key.");
            return;
        }
        ArrayList arrayList3 = new ArrayList(arrayList2);
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            int n2 = arrayList3.indexOf(string);
            if (n2 >= 0) {
                arrayList3.remove(n2);
                System.out.println("Correct:  " + string);
                ++correct;
                continue;
            }
            System.out.println("Spurious: " + string);
            ++spurious;
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            string = (String)arrayList3.get(n);
            System.out.println("Missing:  " + string);
            ++missing;
        }
    }

    static {
        relations = new String[]{"of", "subject", "object"};
        correct = 0;
        spurious = 0;
        missing = 0;
    }
}

