/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Parser.ParseTreeNode;
import Jet.Parser.SynFun;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public class ParseView
extends JFrame {
    private JScrollPane jScrollPane = new JScrollPane();
    private JParseComponent parseComponent;
    public static String[] relations = new String[]{"none", "subject", "object", "of", "apposite", "headC", "pp", "preName", "nameMod"};
    public static String[] features = new String[]{"none", "head"};
    private int i;
    private String relationToShow;
    private String featureToShow;

    public ParseView(String string, Annotation annotation) {
        super(string);
        this.setSize(400, 300);
        this.parseComponent = new JParseComponent();
        this.jScrollPane.getViewport().add(this.parseComponent);
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.buildMenus();
        this.setVisible(true);
        this.parseComponent.init(annotation);
    }

    private void buildMenus() {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("relations");
        this.i = 0;
        while (this.i < relations.length) {
            jMenuItem = new JMenuItem(relations[this.i]);
            jMenuItem.addActionListener(new ActionListener(){
                int j;
                JParseComponent pc;
                {
                    this.j = ParseView.this.i;
                    this.pc = ParseView.this.parseComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ParseView.this.relationToShow = relations[this.j];
                    this.pc.repaint();
                }
            });
            jMenu.add(jMenuItem);
            ++this.i;
        }
        jMenuBar.add(jMenu);
        jMenuItem = new JMenu("features");
        this.i = 0;
        while (this.i < features.length) {
            JMenuItem jMenuItem2 = new JMenuItem(features[this.i]);
            jMenuItem2.addActionListener(new ActionListener(){
                int j;
                JParseComponent pc;
                {
                    this.j = ParseView.this.i;
                    this.pc = ParseView.this.parseComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ParseView.this.featureToShow = features[this.j];
                    this.pc.layOutTree();
                    this.pc.repaint();
                }
            });
            ((JMenu)jMenuItem).add(jMenuItem2);
            ++this.i;
        }
        jMenuBar.add((JMenu)jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    protected class JParseComponent
    extends JComponent {
        ArrayList nodes = new ArrayList();
        HashMap position = new HashMap();
        FontMetrics fm;
        private int height;
        private int verticalSeparation;
        private int horizontalSeparation;
        private int maxX;
        private int maxY;
        private Annotation root;

        JParseComponent() {
        }

        void init(Annotation annotation) {
            this.fm = this.getGraphics().getFontMetrics();
            this.horizontalSeparation = this.fm.charWidth('m');
            this.height = this.fm.getHeight();
            this.verticalSeparation = this.height * 2;
            this.root = annotation;
            this.layOutTree();
        }

        void layOutTree() {
            this.maxX = 0;
            this.maxY = 0;
            this.computePosition(this.root, 10, 10);
            this.setPreferredSize(new Dimension(this.maxX + 50, this.maxY + 50));
        }

        int computePosition(Annotation annotation, int n, int n2) {
            this.nodes.add(annotation);
            int n3 = 0;
            Annotation[] annotationArray = ParseTreeNode.children(annotation);
            if (annotationArray != null) {
                for (int i = 0; i < annotationArray.length; ++i) {
                    int n4 = this.computePosition(annotationArray[i], n + n3, n2 + this.height + this.verticalSeparation);
                    n3 += n4 + this.horizontalSeparation;
                }
                n3 -= this.horizontalSeparation;
            } else {
                Document document = annotation.span().document();
                String string = document.text(annotation).trim();
                n3 = this.fm.stringWidth(string);
            }
            String string = this.nodeName(annotation);
            int n5 = this.fm.stringWidth(string);
            int n6 = Math.max(n3, n5);
            this.position.put(annotation, new Point(n + n6 / 2, n2));
            this.maxX = Math.max(this.maxX, n);
            this.maxY = Math.max(this.maxY, n2);
            return n6;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            for (int i = 0; i < this.nodes.size(); ++i) {
                Object object;
                Annotation annotation = (Annotation)this.nodes.get(i);
                Point point = (Point)this.position.get(annotation);
                String string = this.nodeName(annotation);
                int n = this.fm.stringWidth(string);
                graphics.drawString(string, point.x - n / 2, point.y);
                Annotation[] annotationArray = ParseTreeNode.children(annotation);
                if (annotationArray != null) {
                    for (int j = 0; j < annotationArray.length; ++j) {
                        object = annotationArray[j];
                        Point point2 = (Point)this.position.get(object);
                        graphics.drawLine(point.x, point.y + 2, point2.x, point2.y - this.height);
                    }
                } else {
                    Document document = annotation.span().document();
                    object = document.text(annotation).trim();
                    int n2 = this.fm.stringWidth((String)object);
                    graphics.setColor(Color.blue);
                    graphics.drawString((String)object, point.x - n2 / 2, point.y + this.height + this.verticalSeparation);
                    graphics.drawLine(point.x, point.y + 2, point.x, point.y + this.verticalSeparation);
                    graphics.setColor(Color.black);
                }
                this.displayRelation(annotation, point, graphics);
            }
        }

        private String nodeName(Annotation annotation) {
            String string;
            String string2 = (String)annotation.get("cat");
            if (ParseView.this.featureToShow == "head" && (string = SynFun.getImmediateHead(annotation)) != null) {
                return string2 + " [" + string + "]";
            }
            return string2;
        }

        private void displayRelation(Annotation annotation, Point point, Graphics graphics) {
            if (ParseView.this.relationToShow == null) {
                return;
            }
            Object object = annotation.get(ParseView.this.relationToShow);
            if (object == null || !(object instanceof Annotation)) {
                return;
            }
            Point point2 = (Point)this.position.get(object);
            graphics.setColor(Color.red);
            graphics.drawLine(point.x + 4, point.y + 2, point2.x + 4, point2.y - this.height);
            graphics.setColor(Color.black);
        }
    }
}

