/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.Chunk.TokenClassifier;
import Jet.Console;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class HMMannotator {
    TokenClassifier hmm;
    String[][] tagTable;
    boolean BItag;
    boolean annotateEachToken;
    String zoneToTag;
    boolean trace;
    boolean recordMargin = false;
    boolean recordProbability = false;
    final int LONGEST_ANNOTATION_SPAN = 10;

    public HMMannotator(TokenClassifier tokenClassifier) {
        this.hmm = tokenClassifier;
        this.tagTable = new String[0][4];
        this.BItag = false;
        this.annotateEachToken = true;
        this.zoneToTag = "S";
        this.trace = false;
    }

    public void setTagTable(String[][] stringArray) {
        this.tagTable = stringArray;
    }

    public void readTagTable(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.readTagTable(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readTagTable(BufferedReader bufferedReader) {
        try {
            String string;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                String[] stringArray = string.split("\\s+");
                String[] stringArray2 = new String[4];
                if (stringArray.length == 2) {
                    stringArray2[0] = stringArray[0].intern();
                    stringArray2[3] = string2 = stringArray[1].intern();
                } else if (stringArray.length == 4) {
                    stringArray2[0] = stringArray[0].intern();
                    stringArray2[1] = stringArray[1].intern();
                    stringArray2[2] = stringArray[2].intern();
                    stringArray2[3] = string2 = stringArray[3].intern();
                } else {
                    if (stringArray.length == 1 && stringArray[0].equals("endtags")) break;
                    System.out.println("*** Invalid entry in tag table file: " + string);
                    continue;
                }
                arrayList.add(stringArray2);
            }
            this.tagTable = (String[][])arrayList.toArray((T[])new String[0][0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeTagTable(BufferedWriter bufferedWriter) {
        try {
            for (int i = 0; i < this.tagTable.length; ++i) {
                if (this.tagTable[i][1] == null) {
                    bufferedWriter.write(this.tagTable[i][0] + " " + this.tagTable[i][3]);
                } else {
                    bufferedWriter.write(this.tagTable[i][0] + " " + this.tagTable[i][1] + " " + this.tagTable[i][2] + " " + this.tagTable[i][3]);
                }
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.out.println("Error in HMMannotator.writeTagTable: " + iOException);
            System.exit(0);
        }
    }

    public String[][] getTagTable() {
        return this.tagTable;
    }

    public void setBItag(boolean bl) {
        this.BItag = bl;
    }

    public void setAnnotateEachToken(boolean bl) {
        this.annotateEachToken = bl;
    }

    public void setZoneToTag(String string) {
        this.zoneToTag = string;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setRecordMargin(boolean bl) {
        this.recordMargin = bl;
    }

    public void setRecordProb(boolean bl) {
        this.recordProbability = bl;
    }

    private String tagForAnnotation(Annotation annotation) {
        for (int i = 0; i < this.tagTable.length; ++i) {
            String[] stringArray = this.tagTable[i];
            if (!annotation.type().equals(stringArray[0]) || stringArray[1] != null && !annotation.get(stringArray[1]).equals(stringArray[2])) continue;
            return stringArray[3];
        }
        return null;
    }

    private void annotateForTag(Document document, String string, Annotation[] annotationArray, int n, int n2) {
        if (n2 - n + 1 > 10) {
            return;
        }
        int n3 = annotationArray[n].start();
        int n4 = annotationArray[n2].end();
        Span span = new Span(n3, n4);
        for (int i = 0; i < this.tagTable.length; ++i) {
            String[] stringArray = this.tagTable[i];
            if (!string.equals(stringArray[3])) continue;
            double d = 0.0;
            if (this.recordMargin) {
                d = this.hmm.getLocalMargin(document, annotationArray, string, n, n2);
            }
            FeatureSet featureSet = stringArray[1] == null ? new FeatureSet() : new FeatureSet(stringArray[1], stringArray[2]);
            Annotation annotation = new Annotation(stringArray[0], span, featureSet);
            document.addAnnotation(annotation);
            if (this.recordMargin) {
                annotation.put("margin", new Integer((int)d));
            }
            if (this.trace) {
                Console.println("Annotate " + document.normalizedText(span) + " == " + annotation.toSGMLString());
            }
            return;
        }
    }

    public void train(Document document) {
        Vector<Annotation> vector = document.annotationsOfType(this.zoneToTag);
        if (vector == null) {
            System.out.println("HMMAnnotate.train:  no " + this.zoneToTag + " annotations in document.");
            return;
        }
        for (Annotation annotation : vector) {
            Span span = annotation.span();
            Tokenizer.tokenize(document, span);
            this.trainOnSpan(document, span);
        }
    }

    public void trainOnSpan(Document document, Span span) {
        Object object;
        Annotation[] annotationArray;
        Annotation annotation;
        String string = "other";
        int n = 0;
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = span.start();
        int n3 = span.end();
        n2 = Tokenizer.skipWSX(document, n2, n3);
        string = "other";
        while (n2 < n3 && (annotation = document.tokenAt(n2)) != null) {
            String string2;
            annotationArray = document.annotationsAt(n2);
            String string3 = null;
            object = null;
            for (int i = 0; i < annotationArray.size() && (string3 = this.tagForAnnotation((Annotation)(object = (Annotation)annotationArray.get(i)))) == null; ++i) {
            }
            if (string3 != null) {
                if (n == 0) {
                    if (this.BItag) {
                        string2 = ("B-" + string3).intern();
                        string = ("I-" + string3).intern();
                    } else {
                        string2 = string3;
                        string = string3;
                    }
                    n = ((Annotation)object).span().end();
                } else {
                    System.out.println("Nested tag " + string3 + " ignored.");
                    System.out.println("(tag from annotation " + object + ")");
                    string2 = string;
                }
            } else {
                string2 = string;
            }
            arrayList.add(annotation);
            arrayList2.add(string2);
            n2 = annotation.span().end();
            if (n != 0 && n2 > n) {
                System.out.println("Annotation does not end at token boundary");
                System.out.println("(annotation ends at " + n + ", token boundary is " + n2);
            }
            if (n2 < n) continue;
            n = 0;
            string = "other";
        }
        if (n != 0) {
            System.out.println("Annotation extends past text [sentence] boundary");
            System.out.println("(annotation ends at " + n + ")");
        }
        int n4 = arrayList.size();
        annotationArray = arrayList.toArray(new Annotation[n4]);
        object = arrayList2.toArray(new String[n4]);
        this.hmm.train(document, annotationArray, (String[])object);
    }

    public void train(DocumentCollection documentCollection) {
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.open();
            System.out.println("Training from " + externalDocument.fileName());
            this.train(externalDocument);
        }
    }

    public void annotate(Document document) {
        Vector<Annotation> vector = document.annotationsOfType(this.zoneToTag);
        if (vector == null) {
            System.out.println("HMMAnnotate.annotate:  no " + this.zoneToTag + " annotations in document.");
        } else {
            for (Annotation annotation : vector) {
                Span span = annotation.span();
                this.annotateSpan(document, span);
            }
        }
    }

    public void annotateNbest(Document document, int n, String string) {
        Vector<Annotation> vector = document.annotationsOfType(this.zoneToTag);
        if (vector == null) {
            System.out.println("HMMAnnotate.annotate:  no " + this.zoneToTag + " annotations in document.");
        } else {
            for (Annotation annotation : vector) {
                Span span = annotation.span();
                this.annotateSpanNbest(document, span, n, string);
            }
        }
    }

    public void annotateSpan(Document document, Span span) {
        Annotation[] annotationArray = Tokenizer.gatherTokens(document, span);
        if (annotationArray.length == 0) {
            return;
        }
        String[] stringArray = this.hmm.viterbi(document, annotationArray);
        if (stringArray == null) {
            return;
        }
        this.tagsToAnnotations(document, annotationArray, stringArray);
    }

    public ArrayList annotateSpanNbest(Document document, Span span, int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Annotation[] annotationArray = Tokenizer.gatherTokens(document, span);
        if (annotationArray.length == 0) {
            return arrayList;
        }
        String[] stringArray = this.hmm.viterbi(document, annotationArray);
        if (stringArray == null) {
            return arrayList;
        }
        String string2 = string + "-0";
        document.setCurrentHypothesis(string2);
        this.tagsToAnnotations(document, annotationArray, stringArray);
        arrayList.add(string2);
        if (this.recordProbability) {
            document.annotate("HMMtags", span, new FeatureSet("prob", new Integer((int)this.hmm.getPathProbability())));
        }
        for (int i = 1; i < n && (stringArray = this.hmm.nextBest()) != null; ++i) {
            string2 = string + "-" + i;
            document.setCurrentHypothesis(string2);
            this.tagsToAnnotations(document, annotationArray, stringArray);
            arrayList.add(string2);
            if (!this.recordProbability) continue;
            document.annotate("HMMtags", span, new FeatureSet("prob", new Integer((int)this.hmm.getPathProbability())));
        }
        document.setCurrentHypothesis(null);
        return arrayList;
    }

    private void tagsToAnnotations(Document document, Annotation[] annotationArray, String[] stringArray) {
        if (this.BItag) {
            int n = -1;
            String string = "";
            for (int i = 0; i < annotationArray.length; ++i) {
                Annotation annotation = annotationArray[i];
                String string2 = stringArray[i];
                if (string2.length() > 2 && !string2.substring(0, 2).equals("I-") && n >= 0) {
                    this.annotateForTag(document, string, annotationArray, n, i - 1);
                    n = -1;
                }
                if (string2.length() <= 2 || !string2.substring(0, 2).equals("B-")) continue;
                n = i;
                string = string2.substring(2);
            }
        } else if (this.annotateEachToken) {
            for (int i = 0; i < annotationArray.length; ++i) {
                this.annotateForTag(document, stringArray[i], annotationArray, i, i);
            }
        } else {
            Annotation annotation = annotationArray[0];
            int n = 0;
            String string = stringArray[0];
            for (int i = 1; i < annotationArray.length; ++i) {
                annotation = annotationArray[i];
                if (stringArray[i].equals(string)) continue;
                this.annotateForTag(document, string, annotationArray, n, i - 1);
                string = stringArray[i];
                n = i;
            }
            this.annotateForTag(document, string, annotationArray, n, annotationArray.length - 1);
        }
    }
}

