/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import AceJet.Gazetteer;
import Jet.Lex.Lexicon;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Onoma {
    static Set<String> drugs = new HashSet<String>();

    public static void read(String string) throws IOException {
        String string2;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length != 2) {
                System.out.println("Invalid onoma line: " + string2);
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if (string4.equals("DRG")) {
                drugs.add(string3);
                drugs.add(string3.substring(0, 1).toUpperCase() + string3.substring(1));
            }
            Lexicon.addEntry(Gazetteer.splitAtWS(string3), new FeatureSet("type", string4), "onoma");
            ++n;
        }
        System.out.println("Onoma:  read " + n + " names.");
    }

    public static void tagDrugs(Document document, Span span) {
        int n = span.start();
        while (n < span.end()) {
            Vector<Annotation> vector = document.annotationsAt(n, "ENAMEX");
            if (vector != null && vector.size() > 0) {
                n = vector.get(0).end();
                continue;
            }
            Annotation annotation = document.tokenAt(n);
            if (annotation != null) {
                String string = document.text(annotation).trim();
                if (drugs.contains(string)) {
                    document.annotate("ENAMEX", annotation.span(), new FeatureSet("TYPE", "DRG"));
                }
                n = annotation.end();
                continue;
            }
            return;
        }
    }
}

