/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import AceJet.AceRelationMention;
import AceJet.ChunkPath;
import AceJet.RelationMention;
import AceJet.RelationPattern;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class LearnRelations {
    static boolean useParser = false;
    static boolean useParseCollection = true;
    public static boolean relationTrace = false;
    static String textFileSuffix = ".sgm";
    static String apfFileSuffix = ".apf.xml";
    static Document doc;
    static String currentDoc;
    static SentenceSet sentences;
    static final String[] relations;
    static int maxDistance;
    static HashMap mentionIDMap;
    static HashMap mentionStartMap;
    static TreeSet<AceEntityMention> mentionSet;
    static TreeSet<AceEntityMention> allMentionSet;
    static ArrayList<RelationMention> relMentionList;
    static ArrayList candidates;
    static ArrayList<AceRelation> relationList;
    static TreeMap<String, Integer> patternSet;
    static PrintStream writer;
    static String docName;
    static boolean writingRelations;
    static final boolean expandConjuncts = true;
    static HashMap conjunctf;
    static HashMap conjunctb;
    private static final int mentionWindow = 3;
    private static final int maxPatternLength = 8;
    public static boolean mergeMultipleRelations;

    LearnRelations(String string, String string2) throws IOException {
        writingRelations = true;
        System.out.println("Learning relations ...");
        JetTest.initializeFromConfig(string);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        writer = new PrintStream(new FileOutputStream(string2));
    }

    void finish() {
        LearnRelations.reportPatterns();
        writer.close();
    }

    void learnFromFileList(String string, String string2, String string3) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            String string4 = string2 + currentDoc + textFileSuffix;
            ExternalDocument externalDocument = new ExternalDocument("sgml", string4);
            externalDocument.setAllTags(true);
            externalDocument.open();
            doc = externalDocument;
            LearnRelations.readACErelations(string4, string3 + currentDoc + apfFileSuffix);
            Ace.monocase = Ace.allLowerCase(doc);
            System.out.println(">>> Monocase is " + Ace.monocase);
            Control.processDocument(doc, null, n < 0, n);
            sentences = new SentenceSet(doc);
            candidates = new ArrayList();
            LearnRelations.findSyntacticPatterns(doc);
            LearnRelations.findAdjacencyPatterns();
            LearnRelations.processCandidates();
            LearnRelations.processLeftovers();
        }
    }

    public static void findRelations(String string, Document document, AceDocument aceDocument) {
        doc = document;
        docName = string;
        sentences = new SentenceSet(doc);
        candidates = new ArrayList();
        LearnRelations.findConjuncts(doc);
        LearnRelations.findSyntacticPatterns(doc);
        LearnRelations.findAdjacencyPatterns();
        LearnRelations.predictRelations();
        LearnRelations.relationCoref(aceDocument);
    }

    private static void findSyntacticPatterns(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation[] annotationArray;
                Annotation annotation;
                Object object;
                Annotation annotation2 = vector.elementAt(i);
                for (int j = 0; j < relations.length; ++j) {
                    object = relations[j];
                    if (annotation2.get((String)object) == null) continue;
                    annotation = (Annotation)annotation2.get((String)object);
                    LearnRelations.checkSyntacticRelation(annotation2, (String)object, annotation);
                }
                String string = SynFun.getImmediateHead(annotation2);
                if (string == null) continue;
                object = (Annotation)annotation2.get("subject");
                annotation = (Annotation)annotation2.get("object");
                Annotation annotation3 = (Annotation)annotation2.get("pp");
                if (object != null && annotation != null) {
                    LearnRelations.checkSyntacticRelation((Annotation)object, string, annotation);
                }
                if (annotation3 == null || !((annotationArray = ParseTreeNode.children(annotation3)) != null & annotationArray.length == 2)) continue;
                Annotation annotation4 = annotationArray[0];
                Annotation annotation5 = annotationArray[1];
                String string2 = SynFun.getHead(document, annotation4);
                if (object != null) {
                    LearnRelations.checkSyntacticRelation((Annotation)object, "s-" + string + "-" + string2, annotation5);
                }
                if (annotation == null) continue;
                LearnRelations.checkSyntacticRelation(annotation, "o-" + string + "-" + string2, annotation5);
            }
        }
    }

    private static void checkSyntacticRelation(Annotation annotation, String string, Annotation annotation2) {
        Annotation annotation3 = Resolve.getHeadC(annotation);
        Span span = annotation3.span();
        int n = span.start();
        AceEntityMention aceEntityMention = (AceEntityMention)mentionStartMap.get(new Integer(n));
        if (aceEntityMention == null) {
            return;
        }
        Annotation annotation4 = Resolve.getHeadC(annotation2);
        Span span2 = annotation4.span();
        int n2 = span2.start();
        AceEntityMention aceEntityMention2 = (AceEntityMention)mentionStartMap.get(new Integer(n2));
        if (aceEntityMention2 == null) {
            return;
        }
        if (!LearnRelations.canBeRelated(aceEntityMention, aceEntityMention2)) {
            return;
        }
        if (aceEntityMention.compareTo(aceEntityMention2) < 0) {
            ArrayList arrayList = LearnRelations.recordCandidateWithConjuncts(aceEntityMention, aceEntityMention2);
            LearnRelations.recordSyntacticLink(arrayList, string);
        } else {
            ArrayList arrayList = LearnRelations.recordCandidateWithConjuncts(aceEntityMention2, aceEntityMention);
            LearnRelations.recordSyntacticLink(arrayList, string + "-1");
        }
    }

    private static boolean canBeRelated(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        return !aceEntityMention.entity.id.equals(aceEntityMention2.entity.id);
    }

    private static void findAdjacencyPatterns() {
        if (mentionSet.isEmpty()) {
            return;
        }
        ArrayList<AceEntityMention> arrayList = new ArrayList<AceEntityMention>(mentionSet);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = 1; j <= 3 && i + j < arrayList.size(); ++j) {
                ChunkPath chunkPath;
                AceEntityMention aceEntityMention;
                AceEntityMention aceEntityMention2 = arrayList.get(i);
                if (!LearnRelations.canBeRelated(aceEntityMention2, aceEntityMention = arrayList.get(i + j)) || !sentences.inSameSentence(aceEntityMention2.jetHead.start(), aceEntityMention.jetHead.start()) || (chunkPath = new ChunkPath(doc, aceEntityMention2, aceEntityMention)).size() < 0 || chunkPath.size() > 8 || chunkPath.contains("]")) continue;
                ArrayList arrayList2 = LearnRelations.recordCandidateWithConjuncts(aceEntityMention2, aceEntityMention);
                LearnRelations.recordLinearLink(arrayList2, chunkPath);
            }
        }
    }

    private static RelationMention recordCandidate(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            if (relationMention.mention1 != aceEntityMention || relationMention.mention2 != aceEntityMention2) continue;
            return relationMention;
        }
        RelationMention relationMention = new RelationMention(aceEntityMention, aceEntityMention2);
        candidates.add(relationMention);
        return relationMention;
    }

    private static void processCandidates() {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            AceEntityMention aceEntityMention = relationMention.mention1;
            AceEntityMention aceEntityMention2 = relationMention.mention2;
            if (aceEntityMention.entity.generic || aceEntityMention2.entity.generic) continue;
            String string = aceEntityMention.entity.type;
            String string2 = aceEntityMention2.entity.type;
            String string3 = aceEntityMention.entity.subtype.equals("") ? "*" : aceEntityMention.entity.subtype;
            String string4 = aceEntityMention2.entity.subtype.equals("") ? "*" : aceEntityMention2.entity.subtype;
            String string5 = string + " " + string3 + " " + LearnRelations.getHead(aceEntityMention) + " [ " + relationMention.syntacticLink + " : " + LearnRelations.concat(relationMention.linearLink) + " ] " + string2 + " " + string4 + " " + LearnRelations.getHead(aceEntityMention2);
            LearnRelations.checkRelation(aceEntityMention, string5, aceEntityMention2);
        }
    }

    private static void checkRelation(AceEntityMention aceEntityMention, String string, AceEntityMention aceEntityMention2) {
        if (!LearnRelations.canBeRelated(aceEntityMention, aceEntityMention2)) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < relMentionList.size(); ++i) {
            boolean bl2 = false;
            String string2 = null;
            RelationMention relationMention = relMentionList.get(i);
            if (relationMention.mention1.equals(aceEntityMention) && relationMention.mention2.equals(aceEntityMention2)) {
                bl2 = true;
                string2 = "arg1-arg2";
            } else if (relationMention.mention1.equals(aceEntityMention2) && relationMention.mention2.equals(aceEntityMention)) {
                bl2 = true;
                string2 = "arg2-arg1";
            }
            if (!bl2) continue;
            System.out.println("For " + doc.text(aceEntityMention.jetHead) + " and " + doc.text(aceEntityMention2.jetHead));
            LearnRelations.recordPattern(string2 + " " + string + " --> " + relationMention.relationType + " " + relationMention.relationSubtype);
            relationMention.setAnalyzed();
            bl = true;
        }
        if (!bl) {
            LearnRelations.recordPattern("arg1-arg2 " + string + " --> 0");
        }
    }

    private static void processLeftovers() {
        for (int i = 0; i < relMentionList.size(); ++i) {
            String string;
            String string2;
            RelationMention relationMention = relMentionList.get(i);
            if (relationMention.analyzed) continue;
            AceEntityMention aceEntityMention = relationMention.mention1;
            AceEntityMention aceEntityMention2 = relationMention.mention2;
            String string3 = aceEntityMention.entity.type;
            String string4 = aceEntityMention2.entity.type;
            String string5 = aceEntityMention.entity.subtype.equals("") ? "*" : aceEntityMention.entity.subtype;
            String string6 = string2 = aceEntityMention2.entity.subtype.equals("") ? "*" : aceEntityMention2.entity.subtype;
            if (aceEntityMention.compareTo(aceEntityMention2) < 0) {
                string = "arg1-arg2 " + string3 + " " + string5 + " " + LearnRelations.getHead(aceEntityMention) + " [ " + "0 : " + new ChunkPath(doc, aceEntityMention, aceEntityMention2) + " ] " + string4 + " " + string2 + " " + LearnRelations.getHead(aceEntityMention2);
            } else if (aceEntityMention.compareTo(aceEntityMention2) > 0) {
                string = "arg2-arg1 " + string4 + " " + string2 + " " + LearnRelations.getHead(aceEntityMention2) + " [ " + "0 : " + new ChunkPath(doc, aceEntityMention2, aceEntityMention) + " ] " + string3 + " " + string5 + " " + LearnRelations.getHead(aceEntityMention);
            } else {
                System.err.println("*** Relation with two identical arguments -- ignored.");
                return;
            }
            System.out.println("Leftover -- for " + doc.text(aceEntityMention.jetHead) + " and " + doc.text(aceEntityMention2.jetHead));
            LearnRelations.recordPattern(string + " --> " + relationMention.relationType + " " + relationMention.relationSubtype);
        }
    }

    static String concat(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    static String getHead(AceEntityMention aceEntityMention) {
        Vector<Annotation> vector = doc.annotationsAt(aceEntityMention.jetHead.start(), "constit");
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                String string;
                String[] stringArray;
                Annotation annotation = vector.get(i);
                String string2 = (String)annotation.get("cat");
                if (string2 != "n" && string2 != "pro" && string2 != "name" && string2 != "adj" && string2 != "ven" && (string2 != "det" || annotation.get("tposs") != "t")) continue;
                if (string2 == "name") {
                    stringArray = Resolve.getNameTokens(doc, annotation);
                    if (Ace.gazetteer.isCountry(stringArray)) {
                        return "country";
                    }
                    if (Ace.gazetteer.isNationality(stringArray)) {
                        return "nationality";
                    }
                }
                if ((stringArray = (FeatureSet)annotation.get("pa")) == null || (string = (String)stringArray.get("head")) == null) continue;
                return string.replace(' ', '-').replace('\n', '-');
            }
        }
        return doc.text(aceEntityMention.jetHead).trim().replace(' ', '-').replace('\n', '-');
    }

    static void findConjuncts(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.elementAt(i);
                Annotation annotation2 = (Annotation)annotation.get("conj");
                if (annotation2 == null) continue;
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                arrayList.add(annotation);
                while (annotation2 != null) {
                    arrayList.add(annotation2);
                    annotation2 = (Annotation)annotation2.get("conj");
                }
                LearnRelations.recordConjunct(arrayList);
            }
        }
    }

    static void recordConjunct(ArrayList arrayList) {
        Object object;
        int n;
        String string = "";
        ArrayList<AceEntityMention> arrayList2 = new ArrayList<AceEntityMention>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Annotation)arrayList.get(n);
            AceEntityMention aceEntityMention = LearnRelations.mentionForAnnotation((Annotation)object);
            if (aceEntityMention == null) {
                return;
            }
            arrayList2.add(aceEntityMention);
            if (n == 0) {
                string = aceEntityMention.type;
                continue;
            }
            if (string.equals(aceEntityMention.type)) continue;
            return;
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            object = (AceEntityMention)arrayList2.get(n);
            AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(n + 1);
            conjunctf.put(object, aceEntityMention);
            conjunctb.put(aceEntityMention, object);
            if (!relationTrace) continue;
            System.out.println("Found conjuncts " + doc.text(((AceEntityMention)object).jetHead) + " and " + doc.text(aceEntityMention.jetHead));
        }
    }

    static AceEntityMention mentionForAnnotation(Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        Span span = annotation2.span();
        int n = span.start();
        return (AceEntityMention)mentionStartMap.get(new Integer(n));
    }

    static ArrayList getConjuncts(AceEntityMention aceEntityMention) {
        ArrayList<AceEntityMention> arrayList = new ArrayList<AceEntityMention>();
        arrayList.add(aceEntityMention);
        AceEntityMention aceEntityMention2 = aceEntityMention;
        while (conjunctf.get(aceEntityMention2) != null) {
            aceEntityMention2 = (AceEntityMention)conjunctf.get(aceEntityMention2);
            arrayList.add(aceEntityMention2);
        }
        aceEntityMention2 = aceEntityMention;
        while (conjunctb.get(aceEntityMention2) != null) {
            aceEntityMention2 = (AceEntityMention)conjunctb.get(aceEntityMention2);
            arrayList.add(aceEntityMention2);
        }
        return arrayList;
    }

    static ArrayList recordCandidateWithConjuncts(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        ArrayList<RelationMention> arrayList = new ArrayList<RelationMention>();
        if (aceEntityMention.jetExtent.end() < aceEntityMention2.jetExtent.start() || aceEntityMention2.jetExtent.end() < aceEntityMention.jetExtent.start()) {
            ArrayList arrayList2 = LearnRelations.getConjuncts(aceEntityMention);
            ArrayList arrayList3 = LearnRelations.getConjuncts(aceEntityMention2);
            if (arrayList2.contains(aceEntityMention2)) {
                return arrayList;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                for (int j = 0; j < arrayList3.size(); ++j) {
                    AceEntityMention aceEntityMention3 = (AceEntityMention)arrayList2.get(i);
                    AceEntityMention aceEntityMention4 = (AceEntityMention)arrayList3.get(j);
                    RelationMention relationMention = LearnRelations.recordCandidate(aceEntityMention3, aceEntityMention4);
                    arrayList.add(relationMention);
                }
            }
        } else {
            RelationMention relationMention = LearnRelations.recordCandidate(aceEntityMention, aceEntityMention2);
            arrayList.add(relationMention);
        }
        return arrayList;
    }

    static void recordSyntacticLink(ArrayList arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMention relationMention = (RelationMention)arrayList.get(i);
            relationMention.syntacticLink = string;
        }
    }

    static void recordLinearLink(ArrayList arrayList, ChunkPath chunkPath) {
        ArrayList<String> arrayList2 = chunkPath.getChunks();
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMention relationMention = (RelationMention)arrayList.get(i);
            if (relationMention.linearLink.size() <= chunkPath.size() && (relationMention.linearLink.size() <= 0 || !relationMention.linearLink.get(0).equals("0"))) continue;
            relationMention.linearLink = arrayList2;
        }
    }

    private static void readACErelations(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        LearnRelations.findEntityMentions(aceDocument);
        LearnRelations.findRelationMentions(aceDocument);
    }

    static void findEntityMentions(AceDocument aceDocument) {
        LearnRelations.resetMentions();
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            String string = aceEntity.type;
            String string2 = aceEntity.subtype;
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                LearnRelations.addMention(aceEntityMention);
            }
        }
    }

    static void resetMentions() {
        mentionStartMap = new HashMap();
        mentionIDMap = new HashMap();
        mentionSet = new TreeSet();
        allMentionSet = new TreeSet();
    }

    static void addMention(AceEntityMention aceEntityMention) {
        if (!aceEntityMention.entity.generic) {
            mentionSet.add(aceEntityMention);
        }
        allMentionSet.add(aceEntityMention);
        mentionStartMap.put(new Integer(aceEntityMention.jetHead.start()), aceEntityMention);
        mentionIDMap.put(aceEntityMention.id, aceEntityMention);
    }

    private static void findRelationMentions(AceDocument aceDocument) {
        relMentionList = new ArrayList();
        ArrayList<AceRelation> arrayList = aceDocument.relations;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceRelation aceRelation = arrayList.get(i);
            String string = aceRelation.relClass;
            if (string.equals("IMPLICIT")) continue;
            ArrayList arrayList2 = aceRelation.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceRelationMention aceRelationMention = (AceRelationMention)arrayList2.get(j);
                RelationMention relationMention = new RelationMention(aceRelation.type, aceRelation.subtype);
                relationMention.setArg(1, aceRelationMention.arg1);
                relationMention.setArg(2, aceRelationMention.arg2);
                relMentionList.add(relationMention);
            }
        }
    }

    private static void recordPattern(String string) {
        Integer n;
        if (!string.endsWith("--> 0")) {
            System.out.println(">> " + string);
        }
        int n2 = (n = patternSet.get(string)) == null ? 0 : n;
        patternSet.put(string, new Integer(n2 + 1));
        writer.println(string);
    }

    private static void reportPatterns() {
        for (String string : patternSet.keySet()) {
            int n = patternSet.get(string);
            if (n <= 1) continue;
            System.out.println(n + "X: " + string);
        }
    }

    private static void predictRelations() {
        relMentionList = new ArrayList();
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            if (relationTrace) {
                System.out.println("For relation mention " + i + " = " + relationMention);
            }
            if (relationMention.mention1.entity.generic || relationMention.mention2.entity.generic) {
                if (!relationTrace) continue;
                System.out.println(" mention is generic -- suppressed");
                continue;
            }
            RelationPattern relationPattern = Ace.eve.findMatch(relationMention, maxDistance);
            relationMention.confidence = Ace.eve.getMatchConfidence();
            String string = "0";
            String string2 = "";
            if (relationPattern != null) {
                if (relationTrace) {
                    System.out.println("Best corpus pattern = " + relationPattern.string);
                }
                string = relationPattern.relationType;
                string2 = relationPattern.relationSubtype;
            }
            if (!string.equals("0")) {
                if (string.endsWith("-1")) {
                    relationMention.swapArgs();
                    string = string.substring(0, string.length() - 2);
                }
                relationMention.relationType = string;
                relationMention.relationSubtype = string2;
                relMentionList.add(relationMention);
                relationMention.id = relMentionList.size() + "";
            }
            if (!relationTrace) continue;
            System.out.println("     Predicting ACE relation " + string + " " + string2);
        }
    }

    private static void relationCoref(AceDocument aceDocument) {
        relationList = new ArrayList();
        System.out.println("RelationCoref: " + relMentionList.size() + " relation mentions");
        block0: for (int i = 0; i < relMentionList.size(); ++i) {
            AceRelation aceRelation2;
            RelationMention relationMention = relMentionList.get(i);
            String string = relationMention.mention1.entity.id;
            String string2 = relationMention.mention2.entity.id;
            for (AceRelation aceRelation2 : relationList) {
                if (string != aceRelation2.arg1.id || string2 != aceRelation2.arg2.id || !mergeMultipleRelations && (!relationMention.relationType.equals(aceRelation2.type) || !relationMention.relationSubtype.equals(aceRelation2.subtype))) continue;
                int n = aceRelation2.mentions.size() + 1;
                aceRelation2.addMention(relationMention.toAce(aceRelation2.id + "-" + n, doc, aceDocument));
                continue block0;
            }
            String string3 = docName + "-R" + (relationList.size() + 1);
            aceRelation2 = new AceRelation(string3, relationMention.relationType, relationMention.relationSubtype, "EXPLICIT", aceDocument.findEntity(string), aceDocument.findEntity(string2));
            aceRelation2.addMention(relationMention.toAce((String)string3 + "-1", doc, aceDocument));
            relationList.add(aceRelation2);
            aceDocument.addRelation(aceRelation2);
        }
        System.out.println("RelationCoref: " + relationList.size() + " relations");
    }

    static {
        relations = new String[]{"of", "poss", "nameMod"};
        maxDistance = 21;
        patternSet = new TreeMap();
        writingRelations = false;
        conjunctf = new HashMap();
        conjunctb = new HashMap();
        mergeMultipleRelations = false;
    }
}

