/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceRelationMention;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceRelation {
    public String type;
    public String subtype;
    public String id;
    public String relClass;
    public AceEntity arg1;
    public AceEntity arg2;
    public ArrayList mentions = new ArrayList();
    static HashSet timeRoles = new HashSet();

    public AceRelation(String string, String string2, String string3, String string4, AceEntity aceEntity, AceEntity aceEntity2) {
        this.id = string;
        this.type = string2;
        this.subtype = string3;
        this.relClass = string4;
        this.arg1 = aceEntity;
        this.arg2 = aceEntity2;
    }

    public AceRelation(Element element, AceDocument aceDocument, String string) {
        String string2;
        Object object;
        Element element2;
        int n;
        NodeList nodeList;
        this.id = element.getAttribute("ID");
        this.type = element.getAttribute("TYPE");
        this.subtype = element.getAttribute("SUBTYPE");
        this.relClass = element.getAttribute("CLASS");
        if (AceDocument.ace2005) {
            nodeList = element.getElementsByTagName("relation_argument");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element2 = (Element)nodeList.item(n);
                object = element2.getAttribute("REFID");
                string2 = element2.getAttribute("ROLE");
                if (string2.equals("Arg-1")) {
                    this.arg1 = aceDocument.findEntity((String)object);
                    continue;
                }
                if (string2.equals("Arg-2")) {
                    this.arg2 = aceDocument.findEntity((String)object);
                    continue;
                }
                if (timeRoles.contains(string2)) continue;
                System.err.println("*** invalid ROLE \"" + string2 + "\" for relation");
            }
        } else {
            nodeList = element.getElementsByTagName("rel_entity_arg");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element2 = (Element)nodeList.item(n);
                object = element2.getAttribute("ENTITYID");
                string2 = element2.getAttribute("ARGNUM");
                if (string2.equals("1")) {
                    this.arg1 = aceDocument.findEntity((String)object);
                    continue;
                }
                if (string2.equals("2")) {
                    this.arg2 = aceDocument.findEntity((String)object);
                    continue;
                }
                System.err.println("*** invalid ARGNUM for relation");
            }
        }
        nodeList = element.getElementsByTagName("relation_mention");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            object = new AceRelationMention(element2, aceDocument, string);
            this.addMention((AceRelationMention)object);
        }
    }

    void addMention(AceRelationMention aceRelationMention) {
        this.mentions.add(aceRelationMention);
        aceRelationMention.relation = this;
    }

    public void write(PrintWriter printWriter) {
        printWriter.print("  <relation ID=\"" + this.id + "\" TYPE=\"" + this.type + "\"");
        if (this.subtype != null && !this.subtype.equals("")) {
            printWriter.print(" SUBTYPE=\"" + this.subtype + "\"");
        }
        if (!AceDocument.ace2004) {
            printWriter.print(" CLASS=\"" + this.relClass + "\"");
        }
        printWriter.println(">");
        if (AceDocument.ace2005) {
            printWriter.println("    <relation_argument REFID=\"" + this.arg1.id + "\" ROLE=\"Arg-1\" />");
            printWriter.println("    <relation_argument REFID=\"" + this.arg2.id + "\" ROLE=\"Arg-2\" />");
        } else {
            printWriter.println("    <rel_entity_arg ENTITYID=\"" + this.arg1.id + "\" ARGNUM=\"1\" />");
            printWriter.println("    <rel_entity_arg ENTITYID=\"" + this.arg2.id + "\" ARGNUM=\"2\" />");
        }
        if (!AceDocument.ace2004) {
            printWriter.println("    <relation_mentions>");
        }
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceRelationMention aceRelationMention = (AceRelationMention)this.mentions.get(i);
            aceRelationMention.write(printWriter);
        }
        if (!AceDocument.ace2004) {
            printWriter.println("    </relation_mentions>");
        }
        printWriter.println("  </relation>");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mentions.size(); ++i) {
            stringBuffer.append(this.mentions.get(i).toString());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static {
        timeRoles.add("Time-Within");
        timeRoles.add("Time-Starting");
        timeRoles.add("Time-Ending");
        timeRoles.add("Time-Before");
        timeRoles.add("Time-After");
        timeRoles.add("Time-Holds");
        timeRoles.add("Time-At-Beginning");
        timeRoles.add("Time-At-End");
    }
}

