/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Map;
import java.util.Set;
import tratz.featgen.InitException;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolonymFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_HOLONYM_TYPE = "HolonymType";
    public static final String PARAM_INCLUDE_HYPERNYM_HOLONYMS = "IncludeHypernymHolonyms";
    public static final String PART_TYPE = "Part";
    public static final String MEMBER_TYPE = "Member";
    public static final String SUBSTANCE_TYPE = "Substance";
    private PointerType mPointerType;
    protected boolean mIncludeHypernymHolonyms;

    @Override
    public void init(Map<String, String> params) throws InitException {
        super.init(params);
        String holonymType = params.get(PARAM_HOLONYM_TYPE);
        if (holonymType.equals(PART_TYPE)) {
            this.mPointerType = PointerType.PART_HOLONYM;
        } else if (holonymType.equals(MEMBER_TYPE)) {
            this.mPointerType = PointerType.MEMBER_HOLONYM;
        } else if (holonymType.equals(SUBSTANCE_TYPE)) {
            this.mPointerType = PointerType.SUBSTANCE_HOLONYM;
        }
        String includeHypernymHolonymsString = params.get(PARAM_INCLUDE_HYPERNYM_HOLONYMS);
        if (includeHypernymHolonymsString != null) {
            this.mIncludeHypernymHolonyms = Boolean.parseBoolean(includeHypernymHolonymsString);
        }
    }

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos == POS.NOUN && (entry = WordNet.getInstance().lookupIndexEntry(POS.NOUN, input)) != null) {
            Sense[] senses = entry.getSenses();
            for (int i = 0; i < senses.length && i < this.mMaxSenseNum; ++i) {
                this.addHolonyms(senses[i], productions);
                if (!this.mIncludeHypernymHolonyms) continue;
                this.addHypernyms(productions, senses[i], 1);
            }
        }
        return productions;
    }

    private void addHypernyms(Set<String> productions, Sense sense, int level) {
        if (level < 15) {
            Pointer[] hyperPointers;
            for (Pointer p : hyperPointers = sense.getPointers(PointerType.HYPERNYM)) {
                this.addHypernyms(productions, p.getTargetSense(), level + 1);
            }
        }
    }

    private void addHolonyms(Sense sense, Set<String> productions) {
        Pointer[] pointers;
        for (Pointer p : pointers = sense.getPointers(this.mPointerType)) {
            for (Sense.Key key : p.getTargetSense().getKeys()) {
                productions.add(key.getLemma());
                productions.add("has" + (Object)((Object)this.mPointerType));
            }
        }
    }
}

