/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.types.PropertyHolder;
import edu.umass.cs.mallet.base.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Token
implements Serializable,
PropertyHolder {
    private String text;
    PropertyList properties = null;
    PropertyList features = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Token(String s) {
        this.text = s.intern();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t.intern();
    }

    public String toString() {
        PropertyList.Iterator iter;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText());
        if (this.features != null) {
            iter = this.features.iterator();
            while (iter.hasNext()) {
                iter.next();
                sb.append(" feature(" + iter.getKey() + ")=" + iter.getNumericValue());
            }
        }
        if (this.properties != null) {
            iter = this.properties.iterator();
            while (iter.hasNext()) {
                iter.next();
                if (iter.isNumeric()) {
                    sb.append(" property(" + iter.getKey() + ")=" + iter.getNumericValue());
                    continue;
                }
                sb.append(" property(" + iter.getKey() + ")=" + iter.getObjectValue());
            }
        }
        return sb.toString();
    }

    public FeatureVector toFeatureVector(Alphabet dict, boolean binary) {
        return new FeatureVector(dict, this.features, binary);
    }

    public void setProperty(String key, Object value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    public void setProperties(PropertyList newProperties) {
        this.properties = newProperties;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.lookupObject(key);
    }

    public double getNumericProperty(String key) {
        return this.properties == null ? 0.0 : this.properties.lookupNumber(key);
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.hasProperty(key);
    }

    public void setFeatureValue(String key, double value) {
        this.features = PropertyList.add(key, value, this.features);
    }

    public double getFeatureValue(String key) {
        return this.features == null ? 0.0 : this.features.lookupNumber(key);
    }

    public PropertyList getFeatures() {
        return this.features;
    }

    public void setFeatures(PropertyList pl) {
        this.features = pl;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

