/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelVector;
import edu.umass.cs.mallet.base.types.Labeling;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Label
implements Labeling,
Serializable {
    Object entry;
    LabelAlphabet dictionary;
    int index;
    static final double weightOfLabel = 1.0;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    protected Label() {
        throw new IllegalStateException("Label objects can only be created by their Alphabet.");
    }

    Label(Object entry, LabelAlphabet dict, int index) {
        this.entry = entry;
        this.dictionary = dict;
        assert (dict.lookupIndex(entry, false) == index);
        this.index = index;
    }

    public LabelAlphabet getLabelAlphabet() {
        return this.dictionary;
    }

    public int getIndex() {
        return this.index;
    }

    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    public Object getEntry() {
        return this.entry;
    }

    public String toString() {
        return this.entry.toString();
    }

    public int compareTo(Object o) {
        Label os = (Label)o;
        if (this.index < os.index) {
            return -1;
        }
        if (this.index == os.index) {
            return 0;
        }
        return 1;
    }

    public Label getBestLabel() {
        return this;
    }

    public int getBestIndex() {
        return this.index;
    }

    public double getBestValue() {
        return 1.0;
    }

    public double value(Label label) {
        assert (label.dictionary.equals(this.dictionary));
        return 1.0;
    }

    public double value(int labelIndex) {
        return labelIndex == this.index ? 1.0 : 0.0;
    }

    public int getRank(Label label) {
        assert (label.dictionary.equals(this.dictionary));
        return label == this ? 0 : -1;
    }

    public int getRank(int labelIndex) {
        return labelIndex == this.index ? 0 : -1;
    }

    public Label getLabelAtRank(int rank) {
        assert (rank == 0);
        return this;
    }

    public double getValueAtRank(int rank) {
        assert (rank == 0);
        return 1.0;
    }

    public void addTo(double[] weights) {
        int n = this.index;
        weights[n] = weights[n] + 1.0;
    }

    public void addTo(double[] weights, double scale) {
        int n = this.index;
        weights[n] = weights[n] + 1.0 * scale;
    }

    public int numLocations() {
        return 1;
    }

    public Label labelAtLocation(int loc) {
        assert (loc == 0);
        return this;
    }

    public double valueAtLocation(int loc) {
        assert (loc == 0);
        return 1.0;
    }

    public int indexAtLocation(int loc) {
        assert (loc == 0);
        return this.index;
    }

    public LabelVector toLabelVector() {
        return new LabelVector(this.dictionary, new int[]{this.index}, new double[]{1.0});
    }

    public boolean equals(Object l) {
        if (l instanceof Label) {
            return ((Label)l).compareTo(this) == 0;
        }
        throw new IllegalArgumentException("Cannot compare a Label object with a " + l.getClass().getName() + " object.");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
        out.writeInt(this.index);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dictionary = (LabelAlphabet)in.readObject();
        this.index = in.readInt();
        this.entry = this.dictionary.lookupObject(this.index);
    }
}

