/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.pipe;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class Pipe
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(Pipe.class.getName());
    Pipe parent = null;
    Alphabet dataDict = null;
    Alphabet targetDict = null;
    Class dataDictClass = null;
    Class targetDictClass = null;
    boolean dataAlphabetResolved = false;
    boolean targetAlphabetResolved = false;
    boolean targetProcessing = true;
    VMID instanceId = new VMID();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    private static transient HashMap deserializedEntries = new HashMap();

    public Pipe(Class dataDictClass, Class targetDictClass) {
        assert (dataDictClass == null || Alphabet.class.isAssignableFrom(dataDictClass));
        assert (targetDictClass == null || Alphabet.class.isAssignableFrom(targetDictClass));
        this.dataDictClass = dataDictClass;
        this.targetDictClass = targetDictClass;
    }

    public Pipe() {
        this((Class)null, (Class)null);
    }

    public Pipe(Alphabet dataDict, Alphabet targetDict) {
        this.dataDict = dataDict;
        this.targetDict = targetDict;
    }

    public abstract Instance pipe(Instance var1);

    public Instance pipe(Object data, Object target, Object name, Object source, Instance parent, PropertyList properties) {
        return this.pipe(new Instance(data, target, name, source));
    }

    public void setTargetProcessing(boolean lookForAndProcessTarget) {
        this.targetProcessing = lookForAndProcessTarget;
    }

    public boolean isTargetProcessing() {
        return this.targetProcessing;
    }

    public void setParent(Pipe p) {
        if (p != null) {
            if (this.parent != null) {
                throw new IllegalStateException("Parent already set.");
            }
        } else {
            logger.info("Setting parent to null.");
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.parent = p;
    }

    public Pipe getParent() {
        return this.parent;
    }

    public Pipe getParentRoot() {
        if (this.parent == null) {
            return this;
        }
        Pipe p = this.parent;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    protected Alphabet resolveDataAlphabet() {
        Alphabet pfd;
        if (this.dataAlphabetResolved) {
            throw new IllegalStateException("Data Alphabet already resolved.");
        }
        Alphabet alphabet = pfd = this.parent == null ? null : this.parent.dataDict;
        if (pfd == null) {
            if (this.dataDict == null && this.dataDictClass != null) {
                try {
                    this.dataDict = (Alphabet)this.dataDictClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot create new data dictionary of class " + this.dataDictClass.getName());
                }
                logger.fine("Creating data  Alphabet.");
            }
        } else if (this.dataDict == null) {
            this.dataDict = pfd;
            logger.fine("Assigning data Alphabet from above.");
        } else {
            if (!this.dataDict.equals(pfd)) {
                throw new IllegalStateException("Parent and local data Alphabet do not match.");
            }
            logger.fine("Data Alphabet already matches.");
        }
        this.dataAlphabetResolved = true;
        return this.dataDict;
    }

    protected Alphabet resolveTargetAlphabet() {
        Alphabet pld;
        if (this.targetAlphabetResolved) {
            throw new IllegalStateException("Target Alphabet already resolved.");
        }
        Alphabet alphabet = pld = this.parent == null ? null : this.parent.targetDict;
        if (pld == null) {
            if (this.targetDict == null && this.targetDictClass != null) {
                try {
                    this.targetDict = (Alphabet)this.targetDictClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot create new target dictionary of class " + this.targetDictClass.getName());
                }
            }
        } else if (this.targetDict == null) {
            this.targetDict = pld;
        } else if (!this.targetDict.equals(pld)) {
            throw new IllegalStateException("Parent and local target Alphabet do not match.");
        }
        this.targetAlphabetResolved = true;
        return this.targetDict;
    }

    public Alphabet getDataAlphabet() {
        if (!this.dataAlphabetResolved) {
            this.getParentRoot().resolveDataAlphabet();
        }
        assert (this.dataAlphabetResolved);
        return this.dataDict;
    }

    public Alphabet getTargetAlphabet() {
        if (!this.targetAlphabetResolved) {
            this.getParentRoot().resolveTargetAlphabet();
        }
        assert (this.targetAlphabetResolved);
        return this.targetDict;
    }

    public void setDataAlphabet(Alphabet dDict) {
        if (this.dataDict != null && this.dataDict.size() > 0) {
            throw new IllegalStateException("Can't set this Pipe's Data  Alphabet; it already has one.");
        }
        this.dataDict = dDict;
    }

    public boolean isDataAlphabetSet() {
        System.out.println("Data Alphabet: " + this.dataDict);
        return this.dataDict != null && this.dataDict.size() > 0;
    }

    public void setTargetAlphabet(Alphabet tDict) {
        if (this.targetDict != null) {
            throw new IllegalStateException("Can't set this Pipe's Target Alphabet; it already has one.");
        }
        this.targetDict = tDict;
    }

    public VMID getInstanceId() {
        return this.instanceId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.parent);
        out.writeObject(this.dataDict);
        out.writeObject(this.targetDict);
        out.writeBoolean(this.dataAlphabetResolved);
        out.writeBoolean(this.targetAlphabetResolved);
        out.writeBoolean(this.targetProcessing);
        out.writeObject(this.dataDictClass);
        out.writeObject(this.targetDictClass);
        out.writeObject(this.instanceId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.parent = (Pipe)in.readObject();
        this.dataDict = (Alphabet)in.readObject();
        this.targetDict = (Alphabet)in.readObject();
        this.dataAlphabetResolved = in.readBoolean();
        this.targetAlphabetResolved = in.readBoolean();
        this.targetProcessing = in.readBoolean();
        this.dataDictClass = (Class)in.readObject();
        this.targetDictClass = (Class)in.readObject();
        if (version > 0) {
            this.instanceId = (VMID)in.readObject();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        Object previous = deserializedEntries.get(this.instanceId);
        if (previous != null) {
            return previous;
        }
        if (this.instanceId != null) {
            deserializedEntries.put(this.instanceId, this);
        }
        return this;
    }
}

