/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import pnuts.tools.ConsoleUI;

public class Console {
    private static final int DEFAULT_LINE_BUFFER_SIZE = 40;
    private ConsoleBuffer out = new ConsoleBuffer(40);
    private PipedReader in;
    private PipedWriter pipe = new PipedWriter();
    protected ConsoleUI ui;

    public Console() {
        this.in = new PipedReader();
        try {
            this.pipe.connect(this.in);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void setConsoleUI(ConsoleUI ui) {
        this.ui = ui;
    }

    public ConsoleUI getConsoleUI() {
        return this.ui;
    }

    public Reader getReader() {
        return this.in;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void enter(String str) throws IOException {
        char[] carray = str.toCharArray();
        this.enter(carray, 0, carray.length);
    }

    public void enter(char[] cbuf, int offset, int size) throws IOException {
        this.pipe.write(cbuf, offset, size);
        this.pipe.write("\n");
        this.pipe.flush();
    }

    class ConsoleBuffer
    extends Writer {
        private StringBuffer buf = new StringBuffer();
        private int lineBufferSize;
        private int pendingLines = 0;

        ConsoleBuffer() {
            this(0);
        }

        ConsoleBuffer(int lineBufferSize) {
            this.lineBufferSize = lineBufferSize;
        }

        public synchronized void write(int ch) {
            this.buf.append((char)ch);
            if (this.lineBufferSize > 0 && ch == 10 && ++this.pendingLines > this.lineBufferSize) {
                this.flushBuffer();
                this.pendingLines = 0;
            }
        }

        public synchronized void write(char[] data, int off, int len) {
            for (int i = off; i < len; ++i) {
                this.buf.append(data[i]);
                if (this.lineBufferSize <= 0 || data[i] != '\n' || ++this.pendingLines <= this.lineBufferSize) continue;
                this.flushBuffer();
                this.pendingLines = 0;
            }
        }

        public synchronized void flush() throws IOException {
            if (this.buf.length() > 0) {
                this.flushBuffer();
            }
        }

        public void close() throws IOException {
            this.flush();
        }

        public int size() {
            return this.buf.length();
        }

        private void flushBuffer() {
            String str = this.buf.toString();
            this.buf.setLength(0);
            if (Console.this.ui != null) {
                Console.this.ui.append(str);
            }
        }
    }
}

