/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import pnuts.lang.Context;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.Runtime;

public class PnutsException
extends RuntimeException {
    static final long serialVersionUID = -2040231319919353658L;
    static final Object[] NO_PARAM = new Object[0];
    protected int line;
    protected int column;
    protected Object file;
    protected Throwable throwable;
    protected String contextName;
    protected transient Vector trace;
    protected transient Object operation;

    public PnutsException() {
        this("");
    }

    public PnutsException(String msg) {
        super(msg);
        this.throwable = this;
    }

    public PnutsException(String msg, Context context) {
        this(msg);
        while (context.eval && context.parent != null) {
            context = context.parent;
        }
        this.file = context.getScriptSource();
        this.line = context.beginLine;
        this.column = context.beginColumn;
        this.contextName = context.getName();
    }

    public PnutsException(String key, Object[] param, Context context) {
        this("pnuts.lang.pnuts", key, param, context);
    }

    public PnutsException(String bundleName, String key, Object[] param, Context context) {
        this(Runtime.getMessage(bundleName, key, param), context);
    }

    public PnutsException(Throwable t) {
        this.throwable = t;
    }

    public PnutsException(Throwable t, Context context) {
        while (context.eval && context.parent != null) {
            context = context.parent;
        }
        if (t instanceof PnutsException) {
            PnutsException p = (PnutsException)t;
            this.throwable = p.throwable;
            this.trace = p.trace;
            this.file = p.file;
            this.line = p.line;
            this.column = p.column;
        } else if (t instanceof ParseException) {
            this.throwable = t;
            this.line = ((ParseException)t).getErrorLine();
            this.column = ((ParseException)t).getErrorColumn();
            this.file = context.getScriptSource();
        } else {
            this.throwable = t;
            this.line = context.beginLine;
            this.column = context.beginColumn;
            this.file = context.getScriptSource();
        }
        this.contextName = context.getName();
    }

    public PnutsException(Throwable t, Object operation, Context context) {
        while (context.eval && context.parent != null) {
            context = context.parent;
        }
        if (t instanceof PnutsException) {
            PnutsException p = (PnutsException)t;
            this.throwable = p.throwable;
            this.trace = p.trace;
            this.file = p.file;
            this.line = p.line;
            this.column = p.column;
        } else if (t instanceof ParseException) {
            this.throwable = t;
            this.line = ((ParseException)t).getErrorLine();
            this.column = ((ParseException)t).getErrorColumn();
            this.file = context.getScriptSource();
        } else {
            this.throwable = t;
            this.line = context.beginLine;
            this.column = context.beginColumn;
            this.file = context.getScriptSource();
        }
        this.contextName = context.getName();
        this.operation = operation;
    }

    public String getMessage() {
        if (this.throwable != null && this.throwable != this) {
            return this.throwable.getMessage();
        }
        return super.getMessage();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    String position() {
        StringBuffer buf = new StringBuffer();
        if (this.file != null || this.contextName != null) {
            buf.append('[');
            if (this.contextName != null) {
                buf.append(this.contextName + ", ");
            }
            if (this.file != null) {
                buf.append(this.file);
                if (this.line > 0) {
                    buf.append(" line: " + this.line);
                }
                if (this.column > 0) {
                    buf.append(" column: " + this.column);
                }
            } else if (this.line > 0) {
                buf.append("line: " + this.line);
                if (this.column > 0) {
                    buf.append(" column: " + this.column);
                }
            }
            buf.append(']');
        }
        if (buf.length() > 0) {
            buf.append(":\n");
        }
        return buf.toString();
    }

    public Enumeration getBackTrace() {
        if (this.trace != null) {
            return this.trace.elements();
        }
        return null;
    }

    void printBackTrace(PrintWriter pw, String indent) {
        Enumeration e = this.trace.elements();
        while (e.hasMoreElements()) {
            pw.print(indent);
            Object elem = e.nextElement();
            if (elem == this) {
                pw.println(this.getClass() + "@" + System.identityHashCode(this));
                continue;
            }
            pw.println(elem);
        }
    }

    String trace() {
        StringWriter sw = new StringWriter();
        this.printBackTrace(new PrintWriter(sw), "    ");
        return sw.toString();
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.throwable != null && this.throwable != this) {
            this.throwable.printStackTrace(writer);
        } else {
            super.printStackTrace(writer);
        }
    }

    public void printStackTrace(PrintStream ps) {
        if (this.throwable != null && this.throwable != this) {
            this.throwable.printStackTrace(ps);
        } else {
            super.printStackTrace(ps);
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Object getScriptSource() {
        return this.file;
    }

    void backtrace(TraceInfo traceInfo) {
        if (this.trace == null) {
            this.trace = new Vector();
        }
        this.trace.addElement(traceInfo);
    }

    public String toString() {
        String s = this.position();
        if (this.trace != null) {
            s = s + this.trace();
        }
        if (this.operation != null) {
            s = s + this.operation.toString() + "->";
        }
        return s + this.throwable.getClass().getName() + " : " + this.throwable.getMessage();
    }

    public static class TraceInfo {
        Object target;
        Object frame;
        Object[] arguments;
        Object scriptSource;
        int line;
        int column;

        protected TraceInfo() {
        }

        public TraceInfo(Object frame, Object[] args, Object scriptSource, int line, int column) {
            this(null, frame, args, scriptSource, line, column);
        }

        public TraceInfo(Object target, Object methodName, Object[] args, Object scriptSource, int line, int column) {
            this.target = target;
            this.frame = methodName;
            this.arguments = args;
            this.scriptSource = scriptSource;
            this.line = line;
            this.column = column;
        }

        public Object getScriptSource() {
            return this.scriptSource;
        }

        public Object[] getArguments() {
            return (Object[])this.arguments.clone();
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public Object getFrame() {
            return this.frame;
        }

        public Object getTargetObject() {
            return this.target;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            if (this.target != null) {
                try {
                    sbuf.append(Pnuts.format(this.target));
                }
                catch (Throwable t) {
                    sbuf.append("?");
                }
                sbuf.append(".");
            }
            sbuf.append(String.valueOf(this.frame));
            try {
                String args = Runtime.format(this.arguments, 64);
                sbuf.append("(" + args.substring(1, args.length() - 1) + ")");
            }
            catch (Throwable tt) {
                sbuf.append("(?)");
            }
            if (this.scriptSource != null) {
                sbuf.append(" [");
                sbuf.append(this.scriptSource);
                sbuf.append(':');
                sbuf.append(" line: " + this.line);
                if (this.column >= 0) {
                    sbuf.append(" column: " + this.column);
                }
                sbuf.append(']');
            }
            return sbuf.toString();
        }
    }
}

