/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.FileReader;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.RealBasicEventStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractEventStream;
import opennlp.model.AbstractModel;
import opennlp.model.OnePassDataIndexer;
import opennlp.model.OnePassRealValueDataIndexer;
import opennlp.perceptron.PerceptronTrainer;

public class ModelTrainer {
    public static boolean USE_SMOOTHING = false;
    public static double SMOOTHING_OBSERVATION = 0.1;

    private static void usage() {
        System.err.println("java ModelTrainer [-real] dataFile modelFile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        String string = "maxent";
        int n2 = 100;
        int n3 = 1;
        double d = 1.0;
        if (stringArray.length == 0) {
            ModelTrainer.usage();
        }
        while (stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("-real")) {
                bl = true;
            } else if (stringArray[n].equals("-perceptron")) {
                string = "perceptron";
            } else if (stringArray[n].equals("-maxit")) {
                n2 = Integer.parseInt(stringArray[++n]);
            } else if (stringArray[n].equals("-cutoff")) {
                n3 = Integer.parseInt(stringArray[++n]);
            } else if (stringArray[n].equals("-sigma")) {
                d = Double.parseDouble(stringArray[++n]);
            } else {
                System.err.println("Unknown option: " + stringArray[n]);
                ModelTrainer.usage();
            }
            ++n;
        }
        String string2 = new String(stringArray[n++]);
        String string3 = new String(stringArray[n]);
        try {
            AbstractModel abstractModel;
            FileReader fileReader = new FileReader(new File(string2));
            AbstractEventStream abstractEventStream = !bl ? new BasicEventStream(new PlainTextByLineDataStream(fileReader), ",") : new RealBasicEventStream(new PlainTextByLineDataStream(fileReader));
            GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
            if (string.equals("maxent")) {
                abstractModel = !bl ? GIS.trainModel(abstractEventStream, n2, n3, d) : GIS.trainModel(n2, new OnePassRealValueDataIndexer(abstractEventStream, 0), USE_SMOOTHING);
            } else if (string.equals("perceptron")) {
                System.err.println("Perceptron training");
                abstractModel = new PerceptronTrainer().trainModel(10, new OnePassDataIndexer(abstractEventStream, 0), 0);
            } else {
                System.err.println("Unknown model type: " + string);
                abstractModel = null;
            }
            File file = new File(string3);
            SuffixSensitiveGISModelWriter suffixSensitiveGISModelWriter = new SuffixSensitiveGISModelWriter(abstractModel, file);
            suffixSensitiveGISModelWriter.persist();
        }
        catch (Exception exception) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(exception);
            exception.printStackTrace();
        }
    }
}

