/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.util.Resolvable;

public final class POS
implements Serializable {
    static final long serialVersionUID = 4311120391558046419L;
    public static final POS NOUN = new POS("NOUN", "NOUN_KEY");
    public static final POS VERB = new POS("VERB", "VERB_KEY");
    public static final POS ADJECTIVE = new POS("ADJECTIVE", "ADJECTIVE_KEY");
    public static final POS ADVERB = new POS("ADVERB", "ADVERB_KEY");
    public static final POS[] CATS = new POS[]{NOUN, VERB, ADJECTIVE, ADVERB};
    private static final Map KEY_TO_POS_MAP = new HashMap();
    private static boolean _initialized = false;
    private Resolvable _label;
    private Resolvable _key;
    private transient String _cachedToString = null;

    public static void initialize() {
        if (!_initialized) {
            int n = 0;
            while (n < CATS.length) {
                KEY_TO_POS_MAP.put(CATS[n].getKey(), CATS[n]);
                ++n;
            }
            _initialized = true;
        }
    }

    public static POS getPOSForKey(String string) {
        POS pOS = (POS)KEY_TO_POS_MAP.get(string);
        if (pOS == null) {
            throw new JWNLRuntimeException("DATA_EXCEPTION_004", string);
        }
        return pOS;
    }

    private POS(String string, String string2) {
        this._label = new Resolvable(string);
        this._key = new Resolvable(string2);
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_010", this.getLabel());
        }
        return this._cachedToString;
    }

    public int hashCode() {
        return this._key.toString().hashCode();
    }

    public String getLabel() {
        return this._label.toString();
    }

    public String getKey() {
        return this._key.toString();
    }
}

