/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.util.search;

import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.search.AStarNode;
import edu.umass.cs.mallet.base.util.search.AStarState;
import edu.umass.cs.mallet.base.util.search.MinHeap;
import edu.umass.cs.mallet.base.util.search.PriorityQueue;
import edu.umass.cs.mallet.base.util.search.SearchNode;
import java.util.Iterator;
import java.util.logging.Logger;

public class AStar
implements Iterator {
    private static Logger logger = MalletLogger.getLogger(AStar.class.getName());
    private PriorityQueue q;
    private AStarNode answer;
    private boolean needNext;

    public AStar(AStarState[] initial, int expectedSize) {
        this.q = new MinHeap(expectedSize);
        int i = 0;
        while (i < initial.length) {
            AStarState s = initial[i];
            AStarNode n = new AStarNode(s, null, 0.0);
            n.setPriority(s.completionCost());
            this.q.insert(n);
            ++i;
        }
        this.needNext = true;
    }

    private void lookAhead() {
        if (this.needNext) {
            this.answer = this.search();
            this.needNext = false;
        }
    }

    public boolean hasNext() {
        this.lookAhead();
        return this.answer != null;
    }

    public Object next() {
        return this.nextAnswer();
    }

    public AStarNode nextAnswer() {
        this.lookAhead();
        this.needNext = true;
        return this.answer;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private AStarNode search() {
        while (this.q.size() > 0) {
            AStarNode u = (AStarNode)this.q.extractMin();
            logger.info(u + ": " + u.getPriority());
            if (u.isFinal()) {
                logger.info("Final " + u);
                return u;
            }
            SearchNode.NextNodeIterator i = u.getNextNodes();
            while (i.hasNext()) {
                AStarNode v = (AStarNode)i.nextNode();
                double priority = v.getCost() + v.completionCost();
                logger.info("insert " + v + " at " + priority);
                v.setPriority(priority);
                this.q.insert(v);
            }
        }
        return null;
    }
}

