/*
 * Decompiled with CFR 0.152.
 */
package Jet.Zoner;

import AceJet.Ace;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import Jet.Zoner.SpecialZoner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class SentenceWriter {
    static String dataDir;
    static String outputDir;
    static String fileList;
    static boolean writeXML;
    static boolean inline;
    static final boolean debug = false;
    static final String d = " : ";

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length > 0) {
            if (stringArray.length < 3 || stringArray.length > 4) {
                System.out.println("SentenceWriter must have 3 or 4 arguments:");
                System.out.println("  filelist  dataDirectory  outputDirectory [XMLflag]");
                System.exit(1);
            }
            fileList = stringArray[0];
            dataDir = stringArray[1];
            outputDir = stringArray[2];
            writeXML = stringArray.length == 4;
            inline = writeXML && stringArray[3].equals("inline");
        }
        SentenceWriter.processFileList(fileList);
    }

    private static void processFileList(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            ++n;
            try {
                SentenceWriter.processFile(string2, n);
            }
            catch (Exception exception) {
                System.err.println("Error : " + string + d + n + d + string2 + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private static void processFile(String string, int n) throws IOException {
        System.out.println("\nProcessing document " + n + d + string);
        String string2 = dataDir + string;
        ExternalDocument externalDocument = new ExternalDocument("sgml", string2);
        externalDocument.setAllTags(true);
        externalDocument.open();
        SentenceWriter.split(externalDocument, string);
        if (inline) {
            SentenceWriter.writeInline(externalDocument, string);
        } else {
            String string3 = outputDir + string + ".sent";
            PrintWriter printWriter = new PrintWriter(new FileWriter(string3));
            SentenceWriter.writeSents(externalDocument, string, printWriter);
            printWriter.close();
        }
    }

    private static void split(Document document, String string) {
        SpecialZoner.findSpecialZones(document);
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        if (vector == null) {
            System.out.println("No <TEXT> in " + string + ", skipped.");
            return;
        }
        Vector<Annotation> vector2 = document.annotationsOfType("sentence");
        if (vector2 == null || vector2.size() == 0) {
            for (Annotation annotation : vector) {
                Span span = annotation.span();
                Ace.monocase = Ace.allLowerCase(document);
                SentenceSplitter.split(document, span);
            }
        }
    }

    private static void writeSents(ExternalDocument externalDocument, String string, PrintWriter printWriter) {
        Object object;
        Object object2;
        if (writeXML) {
            object2 = string;
            if (string.indexOf(47) >= 0) {
                object2 = string.substring(string.lastIndexOf(47) + 1);
            }
            printWriter.print("<source_file URI=\"" + (String)object2 + "\"");
            printWriter.println(" SOURCE=\"newswire\" TYPE=\"text\" AUTHOR=\"NYU\">");
            object = Ace.getDocId(externalDocument);
            if (object == null) {
                object = ((String)object2).endsWith(".sgm") ? ((String)object2).substring(0, ((String)object2).length() - 4) : object2;
            }
            printWriter.println("<document DOCID=\"" + (String)object + "\">");
        }
        if ((object2 = externalDocument.annotationsOfType("sentence")) == null) {
            return;
        }
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            Annotation annotation = (Annotation)object.next();
            Span span = annotation.span();
            String string2 = externalDocument.text(span).trim().replace('\n', ' ');
            if (writeXML) {
                externalDocument.shrink(annotation);
                printWriter.println("  <sentence><charseq START=\"" + span.start() + "\"" + " END=\"" + (span.end() - 1) + "\"></charseq>" + "</sentence>");
                continue;
            }
            printWriter.println(span.start() + " " + string2);
        }
        if (writeXML) {
            printWriter.println("</document>");
            printWriter.println("</source_file>");
        }
    }

    private static void writeInline(ExternalDocument externalDocument, String string) {
        Vector<Annotation> vector = externalDocument.annotationsOfType("sentence");
        if (vector != null) {
            int n = 0;
            for (Annotation annotation : vector) {
                annotation.put("ID", "SENT-" + ++n);
            }
        }
        externalDocument.removeAnnotationsOfType("dateline");
        externalDocument.removeAnnotationsOfType("textBreak");
        externalDocument.shrink("sentence");
        externalDocument.setSGMLwrapMargin(0);
        externalDocument.saveAs(outputDir, string);
    }

    static {
        writeXML = false;
        inline = false;
    }
}

