/*
 * Decompiled with CFR 0.152.
 */
package Jet.Lex;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stemmer {
    private static final String DICT_ENCODING = "US-ASCII";
    private static Stemmer defaultStemmer = Stemmer.loadDefaultStemmer();
    private HashMap<String, String> dict = new HashMap();

    public static Stemmer getDefaultStemmer() {
        return defaultStemmer;
    }

    private static Stemmer loadDefaultStemmer() {
        Stemmer stemmer;
        InputStream inputStream = null;
        try {
            inputStream = Stemmer.class.getClassLoader().getResourceAsStream("Jet/Lex/resources/stem.dict");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, DICT_ENCODING);
            Stemmer stemmer2 = new Stemmer();
            stemmer2.loadDictionary(inputStreamReader);
            stemmer = stemmer2;
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return stemmer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDictionary(File file) throws IOException {
        BufferedReader bufferedReader = IOUtils.getBufferedReader(file, DICT_ENCODING);
        try {
            this.loadDictionary(bufferedReader);
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
    }

    public void loadDictionary(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        Pattern pattern = Pattern.compile("\\s+");
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = pattern.split(string);
            String string2 = stringArray[0].intern();
            for (int i = 1; i < stringArray.length; ++i) {
                this.dict.put(stringArray[i].intern(), string2);
            }
        }
    }

    public void tagStem(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("token", span);
        Vector<String> vector2 = this.getPosTags(document, vector);
        assert (vector.size() == vector2.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            Annotation annotation = vector.get(i);
            String string2 = document.text(annotation).trim();
            String string3 = this.getStem(string2, string = vector2.get(i));
            if (string3 == string2) continue;
            annotation.put("stem", string3);
        }
    }

    public String getStem(String string, String string2) {
        if (string.equals("I") || string2.equals("NNP") || string2.equals("NNPS")) {
            return string;
        }
        String string3 = string.toLowerCase();
        boolean bl = string3.equals(string);
        String string4 = this.dict.get(string3);
        if (string4 != null) {
            return string4;
        }
        if (Stemmer.any(string3, "NNS", "VBZ")) {
            return this.getStemInternal(string, string3, "s", bl);
        }
        if (Stemmer.any(string3, "VBD", "VBN")) {
            return this.getStemInternal(string, string3, "ed", bl);
        }
        if (string3.equals("VBG")) {
            return this.getStemInternal(string, string3, "ing", bl);
        }
        if (!bl) {
            return string3;
        }
        return string;
    }

    private String getStemInternal(String string, String string2, String string3, boolean bl) {
        if (string2.endsWith(string3)) {
            return string2.substring(0, string2.length() - string3.length());
        }
        if (!bl) {
            return string2;
        }
        return string;
    }

    private Vector<String> getPosTags(Document document, Vector<Annotation> vector) {
        Vector<String> vector2 = new Vector<String>();
        for (Annotation annotation : vector) {
            Vector<Annotation> vector3 = document.annotationsOfType("constit", annotation.span());
            vector2.add(this.getPosTag(vector3));
        }
        return vector2;
    }

    private String getPosTag(Vector<Annotation> vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return ((String)vector.get(0).get("cat")).toUpperCase();
        }
        for (Annotation annotation : vector) {
            String string;
            Annotation[] annotationArray = (Annotation[])annotation.get("children");
            if (annotationArray != null || (string = (String)annotation.get("cat")) == null) continue;
            return string.toUpperCase();
        }
        return null;
    }

    private static boolean any(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

