/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import AceJet.Ace;
import Jet.HMM.HMM;
import Jet.HMM.HMMemitter;
import Jet.Lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class WordFeatureHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 5000.0f;
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    HashMap LCtokenCount;
    HashMap LCtokenProbability;
    HashMap featureCount;
    HashMap featureProbability;
    HashMap cacheCount;
    double[] inCacheProbability;
    double[] notInCacheProbability;
    double lambda;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
        this.LCtokenCount = new HashMap();
        this.featureCount = new HashMap();
        this.cacheCount = new HashMap();
    }

    public void setCacheCount(String string, int n) {
        this.cacheCount.put(string, new Integer(n));
    }

    public void trainOnInstances(String string, String string2, int n) {
        this.count += n;
        if (Ace.monocase && (this.stateName.startsWith("b-") || this.stateName.startsWith("m-") || this.stateName.startsWith("e-") || this.stateName.startsWith("i-"))) {
            string = this.capitalize(string);
        }
        WordFeatureHMMemitter.incrementHashMap(this.tokenCount, string, n);
        WordFeatureHMMemitter.incrementHashMap(this.LCtokenCount, string.toLowerCase(), n);
        WordFeatureHMMemitter.incrementHashMap(this.featureCount, WordFeatureHMMemitter.wordFeature(string), n);
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                if (!this.hmm.inCache(string, this.hmm.tagsToCache[i])) continue;
                WordFeatureHMMemitter.incrementHashMap(this.cacheCount, this.hmm.tagsToCache[i], 1);
            }
        }
    }

    private String capitalize(String string) {
        if (Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public void computeProbabilities() {
        Integer n;
        double d;
        this.tokenProbability = new HashMap();
        int n2 = 0;
        for (Map.Entry object : this.tokenCount.entrySet()) {
            String string = (String)object.getKey();
            int n3 = (Integer)object.getValue();
            double d2 = Math.log((double)n3 / (double)this.count);
            this.tokenProbability.put(string, new Double(d2));
            if (n3 != 1) continue;
            ++n2;
        }
        this.LCtokenProbability = new HashMap();
        for (Map.Entry entry : this.LCtokenCount.entrySet()) {
            String string = (String)entry.getKey();
            int n4 = (Integer)entry.getValue();
            double d3 = Math.log((double)n4 / (double)this.count);
            this.LCtokenProbability.put(string, new Double(d3));
        }
        this.featureProbability = new HashMap();
        for (Map.Entry entry : this.featureCount.entrySet()) {
            String string = (String)entry.getKey();
            int n5 = (Integer)entry.getValue();
            d = Math.log((double)n5 / (double)this.count);
            this.featureProbability.put(string, new Double(d));
        }
        Integer n6 = (Integer)this.featureCount.get("initCap");
        int n7 = (n6 == null ? 0 : n6) + ((n = (Integer)this.featureCount.get("lowerCase")) == null ? 0 : n);
        if (n7 != 0) {
            d = Math.log((double)n7 / (double)this.count);
            this.featureProbability.put("forcedCap", new Double(d));
        }
        this.lambda = 1.0 / (1.0 + (double)this.tokenCount.size() / (double)this.count);
        this.unseenTokenProbability = Math.log((double)n2 / (double)this.count / 5000.0);
        if (this.hmm.tagsToCache != null) {
            this.inCacheProbability = new double[this.hmm.tagsToCache.length];
            this.notInCacheProbability = new double[this.hmm.tagsToCache.length];
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName);
            }
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                int n8;
                Integer n9 = (Integer)this.cacheCount.get(this.hmm.tagsToCache[i]);
                int n10 = n8 = n9 == null ? 0 : n9;
                if (HMM.probReport) {
                    System.out.println("Cache count[" + this.hmm.tagsToCache[i] + "]=" + n8);
                    System.out.println("inCacheProbability[" + this.hmm.tagsToCache[i] + "]=" + (double)n8 / (double)this.count);
                }
                this.inCacheProbability[i] = Math.log((double)n8 / (double)this.count);
                this.notInCacheProbability[i] = Math.log(1.0 - (double)n8 / (double)this.count);
            }
        }
    }

    public double getProbability(String string, String string2, FeatureSet featureSet) {
        Object object;
        double d;
        double d2 = -8.0;
        boolean bl = featureSet.get("case") == "forcedCap";
        Double d3 = bl || Ace.monocase ? (Double)this.LCtokenProbability.get(string.toLowerCase()) : (Double)this.tokenProbability.get(string);
        if (d3 != null) {
            d = d3;
        } else {
            String string3 = WordFeatureHMMemitter.wordFeature(string);
            if (bl && string3 == "initCap" || Ace.monocase) {
                string3 = "forcedCap";
            }
            d = (object = (Double)this.featureProbability.get(string3)) != null ? this.unseenTokenProbability + (Double)object : this.unseenTokenProbability + d2;
        }
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                object = this.hmm.tagsToCache[i];
                boolean bl2 = this.hmm.inCache(string, (String)object);
                if (bl2) {
                    d += this.inCacheProbability[i];
                    continue;
                }
                d += this.notInCacheProbability[i];
            }
        }
        return d;
    }

    public void print() {
        for (Map.Entry entry : this.featureProbability.entrySet()) {
            String string = (String)entry.getKey();
            double d = (Double)entry.getValue();
            System.out.println("EMIT " + string + " " + d);
        }
    }

    public void store(PrintWriter printWriter) {
        for (Map.Entry object : this.tokenCount.entrySet()) {
            String string = (String)object.getKey();
            int n = (Integer)object.getValue();
            printWriter.println("EMIT " + string + " " + n);
        }
        for (Map.Entry entry : this.cacheCount.entrySet()) {
            String string = (String)entry.getKey();
            int n = (Integer)entry.getValue();
            printWriter.println("PREVTAGGED " + string + " " + n);
        }
    }

    static String wordFeature(String string) {
        int n = string.length();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                bl = false;
            }
            if (!Character.isUpperCase(c)) {
                bl2 = false;
            }
            if (!Character.isLowerCase(c)) {
                bl4 = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                bl5 = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            bl3 = false;
        }
        if (bl) {
            if (n == 2) {
                return "twoDigitNum";
            }
            if (n == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (bl2) {
            return "allCaps";
        }
        if (bl3) {
            return "initCap";
        }
        if (bl4) {
            return "lowerCase";
        }
        if (bl5) {
            return "hyphenated";
        }
        return "other";
    }

    private static void incrementHashMap(HashMap hashMap, String string, int n) {
        Integer n2 = (Integer)hashMap.get(string);
        int n3 = n2 == null ? 0 : n2;
        hashMap.put(string, new Integer(n3 + n));
    }
}

