/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.ActiveLearner;
import Jet.HMM.SentenceWithMargin;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationTool;
import Jet.Tipster.Document;
import java.util.ArrayList;

class InteractiveAnnotator
extends Thread {
    ArrayList sentencesToAnnotate;

    InteractiveAnnotator(ArrayList arrayList) {
        this.sentencesToAnnotate = arrayList;
    }

    public void run() {
        for (int i = 0; i < this.sentencesToAnnotate.size(); ++i) {
            SentenceWithMargin sentenceWithMargin = (SentenceWithMargin)this.sentencesToAnnotate.get(i);
            InteractiveAnnotator.annotate(sentenceWithMargin.document, sentenceWithMargin.sentence);
            if (ActiveLearner.keepLearning) continue;
            return;
        }
    }

    static void annotate(Document document, Annotation annotation) {
        AnnotationTool annotationTool = new AnnotationTool();
        annotationTool.addType('p', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "PERSON")));
        annotationTool.addType('o', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "ORGANIZATION")));
        annotationTool.addType('g', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "GPE")));
        boolean bl = annotationTool.annotateDocument(document, annotation.span());
        if (bl) {
            ActiveLearner.keepLearning = false;
        }
        annotation.put("training", "true");
    }
}

