/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;

public final class DateTime
extends BaseDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -5171125899451703815L;

    public DateTime() {
    }

    public DateTime(DateTimeZone zone) {
        super(zone);
    }

    public DateTime(Chronology chronology) {
        super(chronology);
    }

    public DateTime(long instant) {
        super(instant);
    }

    public DateTime(long instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public DateTime(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public DateTime(Object instant) {
        super(instant, (Chronology)null);
    }

    public DateTime(Object instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public DateTime(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology));
    }

    public DateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public DateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone zone) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, zone);
    }

    public DateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, chronology);
    }

    public DateTime toDateTime() {
        return this;
    }

    public DateTime toDateTimeISO() {
        if (this.getChronology() == ISOChronology.getInstance()) {
            return this;
        }
        return super.toDateTimeISO();
    }

    public DateTime toDateTime(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        if (this.getZone() == zone) {
            return this;
        }
        return super.toDateTime(zone);
    }

    public DateTime toDateTime(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if (this.getChronology() == chronology) {
            return this;
        }
        return super.toDateTime(chronology);
    }

    public DateTime withMillis(long newMillis) {
        return newMillis == this.getMillis() ? this : new DateTime(newMillis, this.getChronology());
    }

    public DateTime withChronology(Chronology newChronology) {
        return (newChronology = DateTimeUtils.getChronology(newChronology)) == this.getChronology() ? this : new DateTime(this.getMillis(), newChronology);
    }

    public DateTime withZone(DateTimeZone newZone) {
        return this.withChronology(this.getChronology().withZone(newZone));
    }

    public DateTime withZoneRetainFields(DateTimeZone newZone) {
        DateTimeZone originalZone;
        if ((newZone = DateTimeUtils.getZone(newZone)) == (originalZone = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        long millis = originalZone.getMillisKeepLocal(newZone, this.getMillis());
        return new DateTime(millis, this.getChronology().withZone(newZone));
    }

    public DateTime withDate(int year, int monthOfYear, int dayOfMonth) {
        Chronology chrono = this.getChronology();
        long instant = this.getMillis();
        instant = chrono.year().set(instant, year);
        instant = chrono.monthOfYear().set(instant, monthOfYear);
        instant = chrono.dayOfMonth().set(instant, dayOfMonth);
        return this.withMillis(instant);
    }

    public DateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        Chronology chrono = this.getChronology();
        long instant = this.getMillis();
        instant = chrono.hourOfDay().set(instant, hourOfDay);
        instant = chrono.minuteOfHour().set(instant, minuteOfHour);
        instant = chrono.secondOfMinute().set(instant, secondOfMinute);
        instant = chrono.millisOfSecond().set(instant, millisOfSecond);
        return this.withMillis(instant);
    }

    public DateTime withFields(ReadablePartial partial) {
        if (partial == null) {
            return this;
        }
        return this.withMillis(this.getChronology().set(partial, this.getMillis()));
    }

    public DateTime withField(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long instant = fieldType.getField(this.getChronology()).set(this.getMillis(), value);
        return this.withMillis(instant);
    }

    public DateTime withFieldAdded(DurationFieldType fieldType, int amount) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (amount == 0) {
            return this;
        }
        long instant = fieldType.getField(this.getChronology()).add(this.getMillis(), amount);
        return this.withMillis(instant);
    }

    public DateTime withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getMillis(), durationToAdd, scalar);
        return this.withMillis(instant);
    }

    public DateTime withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public DateTime withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(period, this.getMillis(), scalar);
        return this.withMillis(instant);
    }

    public DateTime plus(long duration) {
        return this.withDurationAdded(duration, 1);
    }

    public DateTime plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public DateTime plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public DateTime plusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().add(this.getMillis(), years);
        return this.withMillis(instant);
    }

    public DateTime plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().add(this.getMillis(), months);
        return this.withMillis(instant);
    }

    public DateTime plusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().add(this.getMillis(), weeks);
        return this.withMillis(instant);
    }

    public DateTime plusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().add(this.getMillis(), days);
        return this.withMillis(instant);
    }

    public DateTime plusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().add(this.getMillis(), hours);
        return this.withMillis(instant);
    }

    public DateTime plusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().add(this.getMillis(), minutes);
        return this.withMillis(instant);
    }

    public DateTime plusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().add(this.getMillis(), seconds);
        return this.withMillis(instant);
    }

    public DateTime plusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().add(this.getMillis(), millis);
        return this.withMillis(instant);
    }

    public DateTime minus(long duration) {
        return this.withDurationAdded(duration, -1);
    }

    public DateTime minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    public DateTime minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public DateTime minusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().subtract(this.getMillis(), years);
        return this.withMillis(instant);
    }

    public DateTime minusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().subtract(this.getMillis(), months);
        return this.withMillis(instant);
    }

    public DateTime minusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().subtract(this.getMillis(), weeks);
        return this.withMillis(instant);
    }

    public DateTime minusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().subtract(this.getMillis(), days);
        return this.withMillis(instant);
    }

    public DateTime minusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().subtract(this.getMillis(), hours);
        return this.withMillis(instant);
    }

    public DateTime minusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().subtract(this.getMillis(), minutes);
        return this.withMillis(instant);
    }

    public DateTime minusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().subtract(this.getMillis(), seconds);
        return this.withMillis(instant);
    }

    public DateTime minusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().subtract(this.getMillis(), millis);
        return this.withMillis(instant);
    }

    public Property property(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField field = type.getField(this.getChronology());
        if (!field.isSupported()) {
            throw new IllegalArgumentException("Field '" + type + "' is not supported");
        }
        return new Property(this, field);
    }

    public DateMidnight toDateMidnight() {
        return new DateMidnight(this.getMillis(), this.getChronology());
    }

    public YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public TimeOfDay toTimeOfDay() {
        return new TimeOfDay(this.getMillis(), this.getChronology());
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -6983323811635733510L;
        private DateTime iInstant;
        private DateTimeField iField;

        Property(DateTime instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.iInstant);
            oos.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.iInstant = (DateTime)oos.readObject();
            DateTimeFieldType type = (DateTimeFieldType)oos.readObject();
            this.iField = type.getField(this.iInstant.getChronology());
        }

        public DateTimeField getField() {
            return this.iField;
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public DateTime getDateTime() {
            return this.iInstant;
        }

        public DateTime addToCopy(int value) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), value));
        }

        public DateTime addToCopy(long value) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), value));
        }

        public DateTime addWrapFieldToCopy(int value) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), value));
        }

        public DateTime setCopy(int value) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), value));
        }

        public DateTime setCopy(String text, Locale locale) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), text, locale));
        }

        public DateTime setCopy(String text) {
            return this.setCopy(text, null);
        }

        public DateTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public DateTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public DateTime roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public DateTime roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }

        public DateTime roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public DateTime roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        public DateTime roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }
    }
}

