/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.relationship.AsymmetricRelationship;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.data.relationship.SymmetricRelationship;

public abstract class Relationship {
    public static final int INFINITY = Integer.MAX_VALUE;
    private PointerTargetNodeList _nodes;
    private PointerType _type;
    private Synset _sourceSynset;
    private Synset _targetSynset;

    protected Relationship(PointerType pointerType, PointerTargetNodeList pointerTargetNodeList) {
        this(pointerType, pointerTargetNodeList, null, null);
    }

    protected Relationship(PointerType pointerType, Synset synset, Synset synset2) {
        this(pointerType, null, synset, synset2);
    }

    protected Relationship(PointerType pointerType, PointerTargetNodeList pointerTargetNodeList, Synset synset, Synset synset2) {
        this._type = pointerType;
        this._nodes = pointerTargetNodeList;
        this._sourceSynset = synset;
        this._targetSynset = synset2;
    }

    protected Relationship(PointerTargetNodeList pointerTargetNodeList, Relationship relationship) {
        this(relationship.getType(), pointerTargetNodeList, relationship.getSourceSynset(), relationship.getTargetSynset());
    }

    public abstract Relationship reverse();

    public PointerTargetNodeList getNodeList() {
        return this._nodes;
    }

    public PointerTarget getSourcePointerTarget() {
        return ((PointerTargetNode)this._nodes.get(0)).getPointerTarget();
    }

    public PointerTarget getTargetPointerTarget() {
        return ((PointerTargetNode)this._nodes.get(this._nodes.size() - 1)).getPointerTarget();
    }

    public String toString() {
        StringBufferOutputStream stringBufferOutputStream = new StringBufferOutputStream();
        this._nodes.print(new PrintStream(stringBufferOutputStream));
        return stringBufferOutputStream.getStringBuffer().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Relationship) {
            Relationship relationship = (Relationship)object;
            return relationship.getType().equals(this.getType()) && relationship.getSourceSynset().equals(this.getSourceSynset()) && relationship.getTargetSynset().equals(this.getTargetSynset());
        }
        return false;
    }

    public PointerType getType() {
        return this._type;
    }

    public Synset getSourceSynset() {
        return this._sourceSynset;
    }

    public Synset getTargetSynset() {
        return this._targetSynset;
    }

    public int getSize() {
        return this.getNodeList().size();
    }

    public int getDepth() {
        return this.getSize() - 1;
    }

    public static int getImmediateRelationship(IndexWord indexWord, IndexWord indexWord2) throws JWNLException {
        Synset[] synsetArray = indexWord.getSenses();
        String string = indexWord2.getLemma();
        int n = 0;
        while (n < synsetArray.length) {
            if (synsetArray[n].containsWord(string)) {
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    public static RelationshipList findRelationships(Synset synset, Synset synset2, PointerType pointerType) throws JWNLException {
        if (pointerType.isSymmetric()) {
            return SymmetricRelationship.findSymmetricRelationships(synset, synset2, pointerType);
        }
        return AsymmetricRelationship.findAsymmetricRelationships(synset, synset2, pointerType);
    }

    public static RelationshipList findRelationships(Synset synset, Synset synset2, PointerType pointerType, int n) throws JWNLException {
        if (pointerType.isSymmetric()) {
            return SymmetricRelationship.findSymmetricRelationships(synset, synset2, pointerType, n);
        }
        return AsymmetricRelationship.findAsymmetricRelationships(synset, synset2, pointerType, n);
    }

    private static class StringBufferOutputStream
    extends OutputStream {
        private StringWriter writer = new StringWriter();

        private StringBufferOutputStream() {
        }

        public void write(int n) throws IOException {
            this.writer.write(n);
        }

        public StringBuffer getStringBuffer() {
            return this.writer.getBuffer();
        }
    }
}

