/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;

public class IndexWordSet {
    private Map _indexWords = new Hashtable(4, 1.0f);
    private String _lemma;
    private transient String _cachedToString = null;

    public IndexWordSet(String string) {
        this._lemma = string;
    }

    public void add(IndexWord indexWord) {
        this._indexWords.put(indexWord.getPOS(), indexWord);
    }

    public void remove(POS pOS) {
        this._indexWords.remove(pOS);
    }

    public int size() {
        return this._indexWords.size();
    }

    public IndexWord getIndexWord(POS pOS) {
        return (IndexWord)this._indexWords.get(pOS);
    }

    public IndexWord[] getIndexWordArray() {
        IndexWord[] indexWordArray = new IndexWord[this._indexWords.size()];
        return this._indexWords.values().toArray(indexWordArray);
    }

    public Collection getIndexWordCollection() {
        return this._indexWords.values();
    }

    public Set getValidPOSSet() {
        return this._indexWords.keySet();
    }

    public boolean isValidPOS(POS pOS) {
        return this._indexWords.containsKey(pOS);
    }

    public int getSenseCount(POS pOS) {
        return this.getIndexWord(pOS).getSenseCount();
    }

    public String toString() {
        if (this._cachedToString == null) {
            String string = "";
            if (this.size() == 0) {
                string = JWNL.resolveMessage("DATA_TOSTRING_003");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this.getValidPOSSet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(this.getIndexWord((POS)iterator.next()).toString());
                }
                string = stringBuffer.toString();
            }
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_004", string);
        }
        return this._cachedToString;
    }

    public String getLemma() {
        return this._lemma;
    }

    public boolean equals(Object object) {
        return object instanceof IndexWordSet && this.getLemma().equals(((IndexWordSet)object).getLemma());
    }
}

