/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.AnnotationColorEntry;
import Jet.Tipster.AnnotationTool;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class CollectionAnnotationTool
extends JFrame {
    AnnotationTool tool;
    String[] types;

    public static void main(String[] stringArray) {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ACE 05/pre-pilot files.txt";
        String string3 = "pilot event colors.txt";
        CollectionAnnotationTool collectionAnnotationTool = new CollectionAnnotationTool(string2, string3);
        collectionAnnotationTool.setDefaultCloseOperation(3);
    }

    public CollectionAnnotationTool(String string, String string2) {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        AnnotationColor annotationColor = new AnnotationColor(null, string2);
        AnnotationColor.showColors();
        this.createCollectionFrame(documentCollection);
        this.tool = new AnnotationTool();
        ArrayList arrayList = AnnotationColor.colors;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnotationColorEntry annotationColorEntry = (AnnotationColorEntry)arrayList.get(i);
            Annotation annotation = new Annotation(annotationColorEntry.type, null, new FeatureSet(annotationColorEntry.feature, annotationColorEntry.featureValue));
            char c = annotationColorEntry.key;
            this.tool.addType(c, annotation);
            hashSet.add(annotationColorEntry.type);
        }
        this.types = hashSet.toArray(new String[0]);
    }

    private void createCollectionFrame(DocumentCollection documentCollection) {
        if (documentCollection == null) {
            return;
        }
        int n = documentCollection.size();
        Box box = Box.createHorizontalBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(n, 1));
        box.add(jPanel);
        box.add(jPanel2);
        BevelBorder bevelBorder = new BevelBorder(0);
        for (int i = 0; i < n; ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            String string = externalDocument.fileName();
            JCheckBox jCheckBox = new JCheckBox(string);
            jPanel.add(jCheckBox);
            JButton jButton = new JButton("annotate");
            jButton.setBorder(bevelBorder);
            jButton.addActionListener(new DocumentAnnotator(externalDocument, string, jCheckBox));
            jPanel2.add(jButton);
        }
        JScrollPane jScrollPane = new JScrollPane(box);
        this.getContentPane().add(jScrollPane);
        this.setSize(600, Math.min(400, n * 30 + 60));
        this.setTitle("Collection " + documentCollection.getName());
        this.setVisible(true);
    }

    public static void task(String[] stringArray) {
        Container container;
        String string = null;
        String string2 = null;
        if (stringArray.length == 3) {
            string = stringArray[1];
            string2 = stringArray[2];
        } else if (stringArray.length == 1) {
            container = new JFileChooser();
            ((JFileChooser)container).setDialogTitle("Collection to annotate");
            int n = ((JFileChooser)container).showOpenDialog(null);
            if (n != 0) {
                System.exit(1);
            }
            string = ((JFileChooser)container).getSelectedFile().getPath();
            ((JFileChooser)container).setDialogTitle("Color file");
            n = ((JFileChooser)container).showOpenDialog(null);
            if (n != 0) {
                System.exit(1);
            }
            string2 = ((JFileChooser)container).getSelectedFile().getPath();
        } else {
            System.out.println("AnnotateCollection requires 2 arguments: jet -AnnotateCollection <collection> <color file>");
            System.exit(1);
        }
        container = new CollectionAnnotationTool(string, string2);
        ((JFrame)container).setDefaultCloseOperation(3);
    }

    private class DocumentAnnotator
    implements ActionListener {
        ExternalDocument doc;
        String documentName;
        JCheckBox checkBox;

        private DocumentAnnotator(ExternalDocument externalDocument, String string, JCheckBox jCheckBox) {
            this.doc = externalDocument;
            this.documentName = string;
            this.checkBox = jCheckBox;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                public void run() {
                    DocumentAnnotator.this.doc.setSGMLtags(CollectionAnnotationTool.this.types);
                    DocumentAnnotator.this.doc.open();
                    DocumentAnnotator.this.doc.annotateWithTag("TEXT");
                    Vector<Annotation> vector = DocumentAnnotator.this.doc.annotationsOfType("TEXT");
                    if (vector == null || vector.size() == 0) {
                        return;
                    }
                    Annotation annotation = vector.get(0);
                    Span span = annotation.span();
                    SentenceSplitter.split(DocumentAnnotator.this.doc, span);
                    Vector<Annotation> vector2 = DocumentAnnotator.this.doc.annotationsOfType("sentence");
                    if (vector2 == null) {
                        return;
                    }
                    for (Annotation annotation2 : vector2) {
                        Span span2 = annotation2.span();
                        Tokenizer.tokenize(DocumentAnnotator.this.doc, span2);
                    }
                    CollectionAnnotationTool.this.tool.annotateDocument(DocumentAnnotator.this.doc, span);
                    DocumentAnnotator.this.checkBox.setSelected(true);
                    DocumentAnnotator.this.doc.removeAnnotationsOfType("token");
                    DocumentAnnotator.this.doc.setSGMLwrapMargin(0);
                    DocumentAnnotator.this.doc.save();
                }
            };
            thread.start();
        }
    }
}

