/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntityMention;
import AceJet.AceEventMentionArgument;
import Jet.Tipster.Span;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEventMention {
    public String id;
    public ArrayList<AceEventMentionArgument> arguments = new ArrayList();
    public Span extent;
    public Span jetExtent;
    public String text;
    public Span anchorExtent;
    public Span anchorJetExtent;
    public String anchorText;
    public double confidence = 1.0;

    public AceEventMention(String string, Span span, Span span2, String string2) {
        this.id = string;
        this.arguments = new ArrayList();
        this.extent = AceEntityMention.convertSpan(span, string2);
        this.jetExtent = span;
        this.text = string2.substring(this.extent.start(), this.extent.end() + 1);
        this.anchorExtent = AceEntityMention.convertSpan(span2, string2);
        this.anchorJetExtent = span2;
        this.anchorText = string2.substring(this.anchorExtent.start(), this.anchorExtent.end() + 1);
    }

    public AceEventMention(Element element, AceDocument aceDocument, String string) {
        this.id = element.getAttribute("ID");
        NodeList nodeList = element.getElementsByTagName("extent");
        Element element2 = (Element)nodeList.item(0);
        this.extent = AceEntityMention.decodeCharseq(element2);
        this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, string);
        this.text = string.substring(this.extent.start(), this.extent.end() + 1);
        NodeList nodeList2 = element.getElementsByTagName("anchor");
        Element element3 = (Element)nodeList2.item(0);
        this.anchorExtent = AceEntityMention.decodeCharseq(element3);
        this.anchorText = string.substring(this.anchorExtent.start(), this.anchorExtent.end() + 1);
        this.anchorJetExtent = AceEntityMention.aceSpanToJetSpan(this.anchorExtent, string);
        NodeList nodeList3 = element.getElementsByTagName("event_mention_argument");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            Element element4 = (Element)nodeList3.item(i);
            AceEventMentionArgument aceEventMentionArgument = new AceEventMentionArgument(element4, aceDocument);
            this.addArgument(aceEventMentionArgument);
        }
    }

    void addArgument(AceEventMentionArgument aceEventMentionArgument) {
        this.arguments.add(aceEventMentionArgument);
    }

    void setId(String string) {
        this.id = string;
    }

    public void write(PrintWriter printWriter) {
        printWriter.print("    <event_mention ID=\"" + this.id + "\"");
        if (Ace.writeEventConfidence) {
            printWriter.format(" p=\"%5.3f\"", this.confidence);
        }
        printWriter.println(">");
        printWriter.println("      <extent>");
        AceEntityMention.writeCharseq(printWriter, this.extent, this.text);
        printWriter.println("      </extent>");
        printWriter.println("      <anchor>");
        AceEntityMention.writeCharseq(printWriter, this.anchorExtent, this.anchorText);
        printWriter.println("      </anchor>");
        for (int i = 0; i < this.arguments.size(); ++i) {
            AceEventMentionArgument aceEventMentionArgument = this.arguments.get(i);
            aceEventMentionArgument.write(printWriter);
        }
        printWriter.println("    </event_mention>");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.anchorText);
        stringBuffer.append("(");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            AceEventMentionArgument aceEventMentionArgument = this.arguments.get(i);
            stringBuffer.append(aceEventMentionArgument.toString());
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }
}

