function A = nmat(v,blk)
% NMAT   transforms the vector v of length
%              sum_i blk(i)^2
%        into a block diagonal matrix A with block structure blk;
%        v contains the columns of the blocks of A stacked on top
%        of one another.
%
% A = nmat(v,blk)
%
% Note:  nmat returns a sparse matrix if there are more than one
%        block, and a full matrix otherwise
%
% input variables:
%     - v         the vector representation of a block diagonal symmetric matrix
%     - blk       block structure vector
%
% output variables:
%     - A         the block diagonal symmetric matrix

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97

 nblk = length(blk);
 sumsq = sum(blk .* blk);
 n = sum(blk);
 A = zeros(n,n);
 if length(v) ~= sumsq,
    error('nmat: length of v is incompatible with blk');
 end;
 fin = 0;
 bfin = 0;
 start = 1;
 bstart = 1;
 for blkidx = 1:nblk,
    bsize = blk(blkidx);
    bsize2 = bsize*bsize;
    fin = fin + bsize;
    bfin = bfin + bsize2;
    Ablk = reshape(v(bstart:bfin),bsize,bsize);
    A(start:fin,start:fin) = Ablk;
    start = start + bsize;
    bstart = bstart + bsize2;
 end;
 if nblk > 1,
    A = sparse(A);
 end;
%
% END function
