//
//  Real/Expr Package Ver. 1.0
//    Copywrite (c) 1995, 1996 Exact Computation Project
//    written by Koji Ouchi (ouchi@simulation.nyu.edu)
//
//  File: ORourke.cc
//

#include "Expr.h"

int main()
{
  Expr e2[2];
  Expr f2[2];
  Expr s2
    = sqrt(e2[0]) + sqrt(e2[1]) - sqrt(f2[0]) - sqrt(f2[1]);
  
  Expr e3[3];
  Expr f3[3];
  Expr s3
    = sqrt(e3[0]) + sqrt(e3[1])  + sqrt(e3[2])
      - sqrt(f3[0]) - sqrt(f3[1]) - sqrt(f3[2]);
  
  e2[0] = 10;
  e2[1] = 11;
  f2[0] =  5;
  f2[1] = 18;
  
  e3[0] =  5;
  e3[1] =  6;
  e3[2] = 18;
  f3[0] =  4;
  f3[1] = 12;
  f3[2] = 12;
  
  unsigned long r;
  long          a, d;
  
  for (;;)
  {
    cout << "Enter the number of bits for relative error : ";
    cin >> r;
    cout << "Enter the number of bits for absolute error : ";
    cin >> a;
    cout << "Enter the number of digits for outputs : ";
    cin >> d;
    
    s2.approx(r, a);
    cout << " s2 : ";
    s2.print(cout, d);
    cout << endl;
    
    s3.approx(r, a);
    cout << " s3 : ";
    s3.print(cout, d);
    cout << endl;
    cout << flush;
  }
  
  return 0;
}

