.\" @(#)Real.1 0.9 96/12/31
.\" Copyright 1996 Koji Ouchi
.nr X
.TH Real 1 "31 Dec 1996"
.SH NAME
Real \- Class Real
.SH SYNOPSIS
.B #include "Real.h"

.B "Real :: Real();"
.br
.BI "Real :: Real(int " "i" ");"
.br
.BI "Real :: Real(int " "i" ");"
.br
.BI "Real :: Real(long " "l" ");"
.br
.BI "Real :: Real(double " "d" ");"
.br
.BI "Real :: Real(BigInt " "I" ");"
.br
.BI "Real :: Real(BigFloat " "X" ");"
.br
.BI "Real :: Real(Rational " "R" ");"

.B "Real Real :: operator -() const;"
.br
.BI "Real Real :: operator " "[+|-|*|/]" "(const Real& " "x" ") const;"
.br
.BI "Real sqrt(const Real& " "x" ");"

.BI "ostream& operator <<(ostream& " "o, " "const Real& " "x" ");"
.SH DESCRIPTION
This file contains the declarations of all the functions in the class
.B Real.
.P
An instance
.I x
of the class
.B Real
is any numerical object
.I X
of the type
.BR "int, long, double, BigInt, BigFloat, " "or " "Rational."
Here,
.BR "BigInt " "and " "Rational"
are the types of arbitrary-long integers and rational numbers,
respectively. We say that
.I X
is the kernel of
.I x.
.P
The following constructors are supported for
.B Real.
.TP 21
.BI "Real " "x" ";"
This constructs an instance of
.B Real
whose kernel is undefined.
.TP 21
.BI "Real " "x" "(int " "i" ");"
This constructs an instance of
.B Real
whose kernel is
.BI "int " "i."
.TP 21
.BI "Real " "x" "(long " "l" );"
This constructs an instance of
.B Real
whose kernel is
.BI "long " "l."
.TP 21
.BI "Real " "x" "(double " "d" ");"
This constructs an instance of
.B Real
whose kernel is
.BI "double " "d."
.TP 21
.BI "Real " "x" "(BigInt " "I" ");"
This constructs an instance of
.B Real
whose kernel is
.BI "BigInt " "I."
.TP 21
.BI "Real " "x" "(BigFloat " "X" ");"
This constructs an instance of
.B Real
whose kernel is
.BI "BigFloat " "X."
.TP 21
.BI "Real " "x" "(Rational " "R" ");"
This constructs an instance of
.B Real
whose kernel is
.BI "Rational " "R."
.P
An instance of
.B Real
is said to be error-free, unless its kernel is an instance of
.B BigFloat
whose
.I err
component is non-zero.
.P
Over
.B Real,
the operation +,(unary and binary) -, *, / and the function
.B sqrt
are supported. Any of those operations and the function does not cause
overflow or underflow by setting the type of the kernel of the result
appropriately.
.P
Let
.IR "o " "and " "x"
be
.BR "ostream " "and " "Real,"
respectively. Further, let
.I X
be the kernel of
.I x.
Then,
.IB "o " "<< " "x"
puts what is put when the stream operator
.IB "o " "<< " "X"
together with the type of
.I X.
.P
.SH "SEE ALSO"
.B BigFloat (1)
.\"	@(#)Real.1	0.9 of 12/31/96
.\".Ee
