.\" @(#)Expr.1 0.9 96/12/31
.\" Copyright 1996 Koji Ouchi
.nr X
.TH Expr 1 "31 Dec 1996"
.SH NAME
Expr \- Class Expr
.SH SYNOPSIS
.B #include "Expr.h"

.B "Expr :: Expr();"
.br
.BI "Expr :: Expr(Real " "x" ");"

.B "Expr Expr :: operator -() const;"
.br
.BI "Expr Expr :: operator " "[+|-|*|/]" "(const Expr& " "e" ") const;"
.br
.BI "Expr sqrt(const Expr& " "e" ");"

.BI "Real Expr :: approx(unsigned long " "r, " "long " "a" ");"

.BI "ostream& operator <<(ostream& " "o, " "const Expr& " "e" ");"
.br
.BI "ostream& Expr :: print(ostream& " "o, " "long " "d" ");"

.BI "int Expr :: operator " "[==|!=|<|<=|>|>=]" "(const Expr& " "e" ") const;"

.BI "Expr& Expr :: operator =(const Expr& " "e" ");"
.br
.BI "Expr& Expr :: reset(const Expr& " "e" ");"
.SH DESCRIPTION
This file contains the declarations of all the functions in the class
.B Expr.
.P
An instance of
.B Expr
is a node of some rooted DAG (directed acyclic graph).

If
.BI "Expr " "e"
is a leaf of some rooted DAG then, it is a parameter node which can
store some rational value.

If
.BI "Expr " "e"
is an internal node of some rooted DAG, then it is
either
.TP 5
\ 
a unary minus node which has one child
.I f
and represents
.I - f,
or

a binary operator node which has two children
.IR "f " "and " "g"
and represents
.IR "f " "[+|-|*|/] " "g,"
or

a squareroot node which has one child
.I f
and represents
.BI "sqrt(" "f" ")."
.P
If every leaf of the tree rooted at
.BI "Expr " "e"
stores some rational value, then
.I e
can be viewed as an element of some algebraically closed field. We
call this element the exact value of
.I e.
We use the same symbol
.I e
to denote both an instance of
.B Expr
and its exact value.
.P
The following constructors are supported for
.B Expr.
.TP 21
.BI "Expr " "e" ";"
This constructs a parameter node whose exact value is undefined.
.TP 21
.BI "Expr " "e" "(Real " "x" ");"
This constructs a parameter node which stores
.I x.
.TP 21
.BI "Expr " "e" "(int " "i" ");"
This constructs a parameter node which stores
.BI "Real(" "i" ")."
.TP 21
.BI "Expr " "e" "(long " "l" ");"
This constructs a parameter node which stores
.BI "Real(" "l" ")."
.TP 21
.BI "Expr " "e" "(double " "d" ");"
This constructs a parameter node which stores
.BI "Real(" "d" ")."
.TP 21
.BI "Expr " "e" "(BigInt " "I" ");"
This constructs a parameter node which stores
.BI "Real(" "I" ")."
.TP 21
.BI "Expr " "e" "(BigFloat " "X" ");"
This constructs a parameter node which stores
.BI "Real(" "X" ")."
Unless
.I X
is error-free, this constructor is not defined.
.TP 21
.BI "Expr " "e" "(Rational " "R" ");"
This constructs a parameter node which stores
.BI "Real(" "R" ")."
.P
Let
.IR "f " "and " "g"
be
.B Expr.
.TP 25
.BI "Expr " "e = - f" ";"
This constructs a unary minus node which has one child
.I f
and represents
.I - f.
.TP 25
.BI "Expr " "e = f [+|-|*|/] g" ";"
This constructs a binary operator node which has two children
.I f
and
.I g
and represents
.I f [+|-|*|/] g.
.TP 25
.BI "Expr " "e = " "sqrt(" "f" ");"
This constructs a squareroot node which has one child
.I f
and represents
.BI "sqrt(" "f" ")."
.P
An instance of
.B Expr
maintains an approximate value of the instance to some precision.

The precision is a pair
.I [ r, a ]
where
.I r
is a non-negative integer and
.I a
is an integer.
Integers greater than or equal to
.B LONG_MAX
and less than or equal to
.B LONG_MIN
are taken to be positive \(if and -\(if, respectively.

.BI "Real " "x"
is said to approximate
.B Expr
.I e
to precision
.I [ r, a ],
if
.I x
satisfies
.TP 5
\ 
.IR "|e - x| \(<= " "max { " "|e| " "2^" "(- r),"
.RI "2^" "(- a)" " }."
.P
Thus,
.IR "r " "and " "a"
specify the relative error and the absolute error, respectively.

To get an approximate value of
.BI "Expr " "e"
to precision
.I [ r, a ],
the function
.IB "e." "approx(" "r, a" ")"
is used. If neither
.IR "r " "nor " "a"
is specified, then the default precision
.RB "[ " "defRelPrec, defAbsPrec " "]"
is taken. The user can change the default precision anywhere in the
user's program.

An instance of
.BI "Expr " "e"
remembers a
.B Real
approximate value
.I x
of
.I e
and the precision
.I [ r, a ]
to which
.I x
approximates
.I e.
The function
.IB "e." "approx()"
recomputes an approximate value, only if the specified precision is
much stricter than than the precision currently maintained.
.P
The comparison operators ==, !=, <, <=, > and  >= are supported for
.B Expr.
Each of those operators compares its operands exactly. For example,
for
.B Expr
.IR "e " "and " "f, e == f"
becomes true iff the exact values of
.IR "e " "and " "f"
are the same.
.P
The stream operator
.B <<
applied to
.BI "ostream " "o"
and
.BI "Expr " "e"
puts the approximate value of
.I e
currently maintained.

Let
.IR "o " "and " "e"
be
.BR "ostream " "and " "Expr,"
respectively. Then,
.IB "e." "print(" "o, d" ")"
puts
.I d
digits of the approximate value of
.I e.
All the output digits are correct except the very last digit may
deviate by 1. If
.I d
is not specified, the default value
.B defPrtDgt
is taken. The user can change the default precision anywhere in the
user's program.
.P
The semantics of assignments over
.B Expr
is different from the standard one of
.B C++.

Let
.IR "e " "and " "f"
be
.B Expr,
.RI "let " "x"
be
.B Real,
and let
.I P
be an algebraic expression which involves +, (unary and binary) -, *,
/ and
.B sqrt.
Suppose, in a scope
.I S,
there are statements of the form
.TP 5
\ 
.IR "e = P(f)     " "--(1)"
.br
.IR "f = x        " "--(2)."
.P
If (2) precedes (1), and in between (2) and (1) there is no assignment
statement whose left operand is
.I f
then, as
in the standard
.B C++
semantics, the exact value of
.B e
becomes the exact value of
.I P(x)
when (2) is stated.

If (1) precedes (2), and in between (1) and (2) there is no assignment
statement whose left operand is
.I e
then, unlike the standard
.B C++
semantics, the exact value of
.I e
becomes the exact value of
.I P(x)
when (2)
is stated.

Let
.IR "e, f, " "and " "g"
be
.B Expr,
and let
.I P
be an algebraic expression which involves +, (unary and binary) -, *,
/ and
.B sqrt.
Suppose, in a scope
.I S,
there are statements of the form
.TP 5
\ 
.IR "e = P(f)     " "--(1)"
.br
.IR "f = g        " "--(2)."
.P
If (2) precedes (1), and in between (2) and (1) there is no assignment
statement whose left operand is
.I f
then, as
in the standard
.B C++
semantics, the exact value of
.B e
becomes the exact value of
.I P(g)
when (2) is stated.

If (1) precedes (2), and in between (1) and (2) there is no assignment
statement whose left operand is
.I e
then, unlike the standard
.B C++
semantics, the exact value of
.I e
becomes the exact value of
.I P(g)
when (2)
is stated.

Note that the semantics for the assignment operator causes a
side-effect. If, in a scope
.I S,
there is a statement of the form
.TP 5
\ 
.I e = P(f).
.P
Then, in the rest of
.I S,
until
.I e
is assigned to be something else, whenever the assignment operator
whose left operand is
.I f
is stated, the exact value of
.I e
is changed.

Let
.IR "e, f " "and " "g"
be
.B Expr.
The function
.IB "e." "reset()"
sets the exact value of
.I e
to be undefined without affecting any instance other than
.I e
itself. Similarly, the function
.IB "e." "reset(" "f" ")"
sets the exact value of
.I e
to be the exact value of
.I f
without affecting any instance other than
.I e
itself. See the following example:

.IR "     f = " "2;"
.br
.IR "     g = " "3;"
.br
.IB "     e = f + g;      " "//"
.RI " the exact vale of " "e " "is 5"
.br
.IR "     f = " "5;"
.BR "         //  " "the exact vale of "
.IR "e " "is 8"
.br
.IB "     e." "reset();      //"
.RI " the exact vale of " "e " "is undefined"
.br
.IB "     e." "reset(" "f" ");     //"
.RI " the exact value of " "r " "is 5"
.P
.SH "SEE ALSO"
.B BigFloat (1), Real (1)
.\"	@(#)Expr.1	0.9 of 12/31/96
.\".Ee

