.\" @(#)BigFloat.1 0.9 96/12/31
.\" Copyright 1996 Koji Ouchi
.nr X
.TH BigFloat 1 "31 Dec 1996"
.SH NAME
BigFloat \- Class BigFloat
.SH SYNOPSIS
.B #include "BigFloat.h"

.B "BigFloat :: BigFloat();"
.br
.BI "BigFloat :: BigFloat(int " "i" ");"
.br
.BI "BigFloat :: BigFloat(long " "l" ");"
.br
.BI "BigFloat :: BigFloat(double " "d" ");"
.br
.BI "BigFloat :: BigFloat(BigInt " "I" ");"

.B "BigFloat BigFloat :: operator -() const;"
.br
.BI "BigFloat BigFloat :: operator " "[+|-|*|/]" "(const BigFloat& " "x" ") const;"
.br
.BI "BigFloat sqrt(const BigFloat& " "x" ");"

.BI "ostream& operator <<(ostream& " "o, " "const BigFloat& " "x" ");"
.SH DESCRIPTION
This file contains the declarations of all the functions in the class
.B BigFloat.
.P
An instance of
.B BigFloat
is a triple
.I <m, err, exp>
where
.IR "m, err " "and " "exp"
are of the type
.BR "BigInt, unsigned long " "and " "long,"
respectively. Here,
.B BigInt
is the type of arbitrary-long integers. A triple
.I <m, err, exp>
represents any real number in the interval
.TP 5
\ 
.IR "[(m - err) * " "B^" "exp, (m + err) * " "B^" "exp]"
.P
where B is 2^14. If a real number
.I X
is represented by
.BI "BigFloat " "x,"
then we say that
.I X
belongs to
.I x.

An instance of
.B BigFloat
is said to be error-free, if its
.I err
component is 0.
.P
The following constructors are supported for
.B BigFloat.
.TP 23
.BI "BigFloat " "x" ";"
This constructs an instance of
.B BigFloat
whose components are undefined.
.TP 23
.BI "BigFloat " "x" "(int " "i" ");"
This constructs an instance of
.B BigFloat
.IR "<i, " "0, 0>."
.TP 23
.BI "BigFloat " "x" "(long " "l" ");"
This constructs an instance of
.B BigFloat
.IR "<l, " "0, 0>."
.TP 23
.BI "BigFloat " "x" "(double " "d" ");"
This constructs an instance of
.B BigFloat
.IR  "<m, " "0, " "exp>"
so that
.br
.IR "     m * " "B^" "exp = d."
.TP 23
.BI "BigFloat " "x" "(BigInt " "I" ");"
This constructs an instance of
.B BigFloat
.IR "<I, " "0, 0>."
.P
Over
.B BigFloat,
the operation +,(unary and binary) -, *, / and the function
.B sqrt
are supported. Let
.IR "x " "and " "y"
be
.B BigFloat.
Then, for any real number
.IR "X " "and " "Y,"
if
.IR "X " "and " "Y"
belong to
.IR "x " "and " "y,"
respectively, then
.TP 5
\ 
.I - X
belongs to
.I - x,

.IR "X " "[+|-|*|/] " "Y"
belongs to
.IR "x " "[+|-|*|/] " "y"
and

.BI "sqrt(" "X" ")"
belongs to
.BI "sqrt(" "x" ")."
.P
Let
.IR "o " "and " "x"
be
.BR "ostream " "and " "BigFloat,"
respectively. Then,
.IB "o " "<< " "x"
puts the string of the form
.TP 5
\ 
.IB "d0 \. d1 d2 \.\.\. dl " "e " "\(+- D"
.P
on
.I o
so that, for any real number
.I X
which belongs to
.I x,
the difference between
.I X
and the real number
.TP 5
\ 
.IR "(d0 + d1 * " "10^(- 1) + " "d2 * " "10^(- 2) +"
.br
.IR "                ... + dl * " "10^(- " "l)) * " "10^(" "D -l)"
.P
is at most
.RI "10^(" "D - l)."
Intuitively, all the shown digits are correct except the last digit
may deviate by 1. For example, if
.IB "o " "<< " "x"
outputs
.RB "2.99 " "e " "- 2,"
then
.I x
represents any real number between .0298 and .03.
.P
.\"	@(#)BigFloat.1	0.9 of 12/31/96
.\".Ee

