function path = findpath(G)
    if nargin < 1
        s = [1 3 3 4 6 6 7 8 7 5];
        t = [2 4 5 5 1 8 1 3 2 8];
        G = digraph(s,t);
        plot(G);
        hold on;
    end
    edges = table2array(G.Edges);
    Gundirected = graph(edges(:,1),edges(:,2));

    v = 1;
    [~,D] = shortestpathtree(Gundirected,'all',v);
    s = find(D==max(D),1);
    [~,D] = shortestpathtree(Gundirected,'all',s);
    t = find(D==max(D),1);
    TR = shortestpathtree(Gundirected,s,t,'OutputForm','cell');
    path = TR{1};
end