classdef arrayindexing
    %a collection for functions, which simplify indexing higher dimensional arrays
    methods(Static)
        function Index = sub2indV(X, Vlim)
            k     = [1, cumprod(X)];
            Index = sum(k(1:length(Vlim)) .* (Vlim - 1)) + 1;
        end
        function v = ind2subV(Vlim, ind)
            ind = ind-1;
            v = zeros(1,0);
            for i = 1:length(Vlim)
                v(i) = 1+mod(ind,Vlim(i));
                ind = (ind-v(i)+1)/Vlim(i);
            end
        end
        function [v,ready] = updateindexvec(v,vLim)
            ready = true;       % Assume that the WHILE loop is ready
            for k = 1:length(v)
                v(k) = v(k) + 1;
                if v(k) <= vLim(k)
                    ready = false;  % No, WHILE loop is not ready now
                    break;          % v(k) increased successfully, leave "for k" loop
                end
                v(k) = 1;         % Reset v(k), proceed to next k
            end
        end
    end
end