import java.awt.Choice;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Label;
import java.awt.Panel;
import java.awt.GridLayout;
import java.awt.Font;

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import java.awt.event.*;

/**
 * Maintains a voronoi diagram as a list of points and their associated polys.
 * Supports testing and adding points plus some utility operations.  See
 * alg.html for algorithm specifics.
 *
 * Main method constructs a default interface, and can initialize from a file
 * of points representing the moves of two players.
 */
//============================================================================
public class Voronize {
//    final double F = .0000001; // Fudge factor
//    final double F = 0; // Fudge factor
    final double FUDGE = .0000001;

    public final int W;
    public final int H;
    public final PointDouble UL;
    public final PointDouble UR;
    public final PointDouble LL;
    public final PointDouble LR;
    public Vector points;
    public Vector ppolys;

    public static int MaxPlayers = 25;
    public static int BoardSize = 400;
    public static netServer ns;
    public static VPanel vp;

    public static Choice turnsChoice = new Choice ();
    public static Choice timeChoice = new Choice ();
    public static Choice humansChoice = new Choice ();

    public static Frame ScoreBoardFrame = new Frame ("Score Board");
    public static Panel ScoreBoard = new Panel ();
    public static Label ScoreLabels[];
    public static Label TimeLabels[];

    //========================================================================
    public Voronize(int w, int h) {
	W = w;
	H = h;
	UL = new PointDouble(  0,   0);
	UR = new PointDouble(W-1,   0);
	LL = new PointDouble(  0, H-1);
	LR = new PointDouble(W-1, H-1);
	clear();
    }

    //========================================================================
    public void clear() {
    points = new Vector();
    ppolys = new Vector();
    }
    public Vector getPoints() {
    return points;
    }
    public Vector getPPolys() {
    return ppolys;
    }
    int count;
    public void set(Vector p) {
    count = 0;
    points = p;
    ppolys = new Vector();
    for(int k = 0; k < p.size(); k++)
        ppolys.addElement(new PolarPoly());
    for(int k = 0; k < p.size(); k++) {
        VLine[] bis = getBisectors(k);
        addPoint(k, bis, false);
    }
    }
    public double[] getHeatMap() {
    Point p = new Point(0, 0);
    double[] map = new double[W*H];
    for(int y = 0; y < H; y++) {
        System.out.println("y: " + y);
        for(int x = 0; x < W; x++) {
        p.x = x;
        p.y = y;
        map[y*W+x] = points.contains(p) ? 0.0 : testPoint(p).area();
        }
    }
    return map;
    }
    public PolarPoly testPoint(Point p) {
    PolarPoly pp = new PolarPoly();
    VLine[] bis = getBisectors(p);
    getPoly(-1, pp, p, 0, bis, true);
    return pp;
    }
    public void addPoint(Point p) {
    points.addElement(p);
    ppolys.addElement(new PolarPoly());
    VLine[] bis = getBisectors(points.size()-1);
    addPoint(points.size()-1, bis, true);
    }

    public void addPoint(int k, VLine[] bis, boolean incremental) {
    if(incremental)
        for(int i = 0; i < bis.length-4; i++)
        prune(i, bis[i]);
    int start = incremental ? 0 : k+1;
    getPoly(k, (PolarPoly)ppolys.elementAt(k), (Point)points.elementAt(k), start, bis, false);
    }
    private void getPoly(int k, PolarPoly pp, Point newpt, int start, VLine[] bis, boolean testing) {
        //System.out.println("adding: " + k + ": " + newpt.x + "," + newpt.y);
    for(int i = start; i < bis.length-1; i++) {
        for(int j = i+1; j < bis.length; j++) {
        PointDouble intpt = bis[i].getIntersection(bis[j]);
        if(intpt != null) {
            VLine testint = new VLine(newpt.x, newpt.y, intpt.x, intpt.y);
                    //System.out.println(" int: " + intpt.x + "," + intpt.y);
            if(isGood(k, i, j, testint, intpt, bis, newpt)) {
            pp.addPoint(intpt);
            if(!testing) {
                count++;
                if(i < bis.length-4)
                ((PolarPoly)ppolys.elementAt(i)).addPoint(intpt);
                if(j < bis.length-4)
                ((PolarPoly)ppolys.elementAt(j)).addPoint(intpt);
            }
            }
        }
        }
    }
    }
    private boolean isGood(int k, int i, int j, VLine testint, PointDouble intpt, VLine[] bis, Point ctr) {
    boolean OK = true;
    int m = 0;
    do {
        if((m!=i && m!=j && m!=k) || m >= bis.length-4) {
        PointDouble xp = testint.getIntersection(bis[m]);
                // is there an intersection point between the end points that is not one of the end points?
        if(xp!=null &&
                   Math.min(ctr.x, intpt.x) <= xp.x && xp.x <= Math.max(ctr.x, intpt.x) &&  // between x points
                   Math.min(ctr.y, intpt.y) <= xp.y && xp.y <= Math.max(ctr.y, intpt.y) &&  // between y points
                   (Math.abs(ctr.x-xp.x) > FUDGE || Math.abs(ctr.y-xp.y) > FUDGE) &&        // not the same as ctr
                   (Math.abs(intpt.x-xp.x) > FUDGE || Math.abs(intpt.y-xp.y) > FUDGE)) {    // not the same as intpt
                    //System.out.println(" bad xp: " + xp.x + "," + xp.y);
            OK = false;
                }
        }
        m++;
    } while(OK && m<bis.length);
    return OK;
    }
    private void prune(int index, VLine line) {
    PolarPoly pp = (PolarPoly)ppolys.elementAt(index);
    Point pt = (Point)points.elementAt(index);
    double goodside = line.eval(pt);
    int N = pp.getSize();
    for(int i = N-1; i >=0; i--) {
        PointDouble p = pp.getPoint(i);
        double e = line.eval(p);
        if(Math.abs(e) < .01)
        e = 0;
        if(e*goodside < 0)
        pp.removePoint(i);
    }
    }
    // find perpendicular bisectors of points[index]
    // add screen edge bisectors
    private VLine[] getBisectors(int ind) {
    VLine[] lines = new VLine[points.size()+3];
        Point p = (Point)points.elementAt(ind);
    int cnt = 0;
    for(int i = 0; i < points.size(); i++)
            if(i != ind)
            lines[cnt++] = getPerpBisect(p, (Point)points.elementAt(i));
    lines[cnt++] = new VLine(UL, UR);
    lines[cnt++] = new VLine(UR, LR);
    lines[cnt++] = new VLine(LR, LL);
    lines[cnt++] = new VLine(LL, UL);
    return lines;
    }
    public VLine[] getBisectors(Point p) {
        VLine[] lines = new VLine[points.size()+4];
        int i;
        for(i = 0; i < points.size(); i++)
            lines[i] = getPerpBisect(p, (Point)points.elementAt(i));
        lines[i++] = new VLine(UL, UR);
        lines[i++] = new VLine(UR, LR);
        lines[i++] = new VLine(LR, LL);
        lines[i++] = new VLine(LL, UL);
        return lines;
    }
    // get the perpendicular bisector of the line between p1 and p2
    private VLine getPerpBisect(PointDouble p1, PointDouble p2) {
    PointDouble center = new PointDouble((p1.x+p2.x)/2.0, (p1.y+p2.y)/2.0);
    PointDouble newp1 = new PointDouble(-(p1.y-center.y)+center.x, p1.x-center.x+center.y);
    PointDouble newp2 = new PointDouble(-(p2.y-center.y)+center.x, p2.x-center.x+center.y);
    return new VLine(newp1, newp2);
    }
    private VLine getPerpBisect(Point p1, Point p2) {
    return getPerpBisect(new PointDouble(p1.x, p1.y), new PointDouble(p2.x, p2.y));
    }
    private static Vector readPoints(String filename) throws IOException {
    java.io.BufferedReader in = new java.io.BufferedReader(new java.io.FileReader(filename));
    Vector v = new Vector();
    String line;
    while((line = in.readLine()) != null) {
        java.util.StringTokenizer t = new java.util.StringTokenizer(line);
        int x = Integer.parseInt(t.nextToken());
        int y = Integer.parseInt(t.nextToken());
        v.addElement(new Point(x, y));
    }
    return v;
    }

    //========================================================================
    public static void main(String[] args) {
	if(args.length > 1) {
	    System.err.println("usage: Voronize [port]");
	    System.exit(1);
	}

	Voronize v = new Voronize(BoardSize+2, BoardSize+2);
    //Voronize v = new Voronize(BoardSize, BoardSize);
	Frame f = new Frame("Voronoi Competition");

	f.addWindowListener(new java.awt.event.WindowAdapter() {
		public void windowClosing(java.awt.event.WindowEvent e) {
		    System.exit(0);
		}
	    });

	f.setLayout(new BorderLayout());
	vp = new VPanel(v);
	vp.setPreferredSize(new java.awt.Dimension(v.W, v.H));

        Color[] colors =
        {
        new Color(255, 200, 200),
        new Color(200, 200, 255),
        new Color(255, 0, 0),
        new Color(0, 255, 0),
        new Color(0, 0, 255),
        new Color(0, 255, 255),
        new Color(255, 0, 255),
        new Color(255, 255, 0),
        new Color(150, 0, 0),
        new Color(0, 150, 0),
        };

    MaxPlayers = colors.length;
	vp.setColors(colors);

	f.add(vp, BorderLayout.CENTER);
	java.awt.Panel p = new java.awt.Panel();

	p.setBackground(Color.lightGray);
	//p.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
    p.setLayout(new GridLayout(8, 1));

    ButAct ba = new ButAct(v, vp);

	Button clearBut;
	p.add(clearBut = new Button("Reset"));
	clearBut.addActionListener(ba);

    Button startBut;
    p.add(startBut = new Button("Start"));
    startBut.addActionListener(ba);


    ChoiceListener ChoiceL = new ChoiceListener (v, vp);

    Label cl = new Label ("Human Players:");
    p.add(cl);

    p.add (humansChoice);
    for (int i=0; i<=5; i++)
        humansChoice.add (Integer.toString(i));
    humansChoice.select ("0");
    humansChoice.addItemListener(ChoiceL);

    cl = new Label ("Turns:");
    p.add(cl);

    p.add (turnsChoice);
    for (int i=1; i<=25; i++)
        turnsChoice.add (Integer.toString(i));
    turnsChoice.select ("7");
    turnsChoice.addItemListener(ChoiceL);
    vp.StartTurns = 7;

    cl = new Label ("Player Time Limit:");
    p.add(cl);

    p.add (timeChoice);
    for (int i=0; i<=1800; i+=30)
        timeChoice.add (Integer.toString(i));
    timeChoice.select ("180");
    timeChoice.addItemListener(ChoiceL);
    vp.PlayerTimeLimit = 180;


	f.add(p, BorderLayout.WEST);
	f.pack();
	f.setVisible(true);

    //--------------------------------------------

    GridLayout gl = new GridLayout (10,2);
    gl.setHgap(5);
    gl.setVgap(5);
    ScoreBoard.setLayout(gl);
    //ScoreBoard.setBackground(Color.GRAY);

    ScoreLabels = new Label[colors.length];
    TimeLabels = new Label[colors.length];

    Font font1 = new Font ("Dialog", Font.PLAIN, 20);

    for (int i=0; i<colors.length; i++)
    {
        Label l = new Label ("Player " + (i+1) + ":  ");
        Label tl = new Label ("TIME:  ");

        l.setFont (font1);
        l.setBackground(colors[i]);
        ScoreBoard.add (l);
        ScoreLabels[i] = l;

        tl.setFont (font1);
        tl.setBackground(colors[i]);
        ScoreBoard.add (tl);
        TimeLabels[i] = tl;
    }

    ScoreBoardFrame.setSize(400,400);
    ScoreBoardFrame.add (ScoreBoard);
    //ScoreBoardFrame.pack();
    ScoreBoardFrame.setVisible(true);

    //--------------------------------------------

    TimerThread PTimer = new TimerThread (v, vp);
    Thread thread = new Thread(PTimer);
    thread.start();

    String port = new String();
    if (args.length == 1)
        port = args[0];

    ns = new netServer (port, v, vp, colors.length);
    vp.resetGame ();
    ns.go();
    }

}

//============================================================================
class ChoiceListener implements java.awt.event.ItemListener
{
    private Voronize vo;
    private VPanel vp;

    public ChoiceListener (Voronize vo, VPanel vp)
    {
        this.vo = vo;
        this.vp = vp;
    }

    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getItemSelectable();

        if (ie.getStateChange() == ItemEvent.SELECTED) {

            if (source == vo.turnsChoice)
            {
                int i = Integer.parseInt(vo.turnsChoice.getSelectedItem());
                vp.StartTurns = i;
                vp.clear();
            }

            if (source == vo.timeChoice)
            {
                int i = Integer.parseInt(vo.timeChoice.getSelectedItem());
                vp.PlayerTimeLimit = i;
                vp.clear();
            }

            if (source == vo.humansChoice)
            {
                int i = Integer.parseInt(vo.humansChoice.getSelectedItem());
                vp.HumanPlayers = i;
                vp.clear();
            }

        }
    }
}

class ButAct implements java.awt.event.ActionListener
{
    private Voronize vo;
    private VPanel vp;
    public ButAct(Voronize vo, VPanel vp)
    {
        this.vo = vo;
        this.vp = vp;
    }

    public void actionPerformed(java.awt.event.ActionEvent e)
    {
        Button b = (Button)e.getSource();

        if (b.getLabel().equals("Reset"))
        {
            vp.clear();


            for (int i=0; i<vo.MaxPlayers; i++)
            {
                vo.ScoreLabels[i].setText ("Player " + (i+1) + ":  ");
                vo.TimeLabels[i].setText ("TIME:  ");
            }

        }

        if (b.getLabel().equals("Start"))
        {
            vp.rc = new ReadyChecker(vp.NumPlayers);
            vp.setNumPlayers(vp.NumPlayers + vp.HumanPlayers);
            vp.gs.update(true);
            vp.tc.changeTurn(1);

        }
    }
}


//============================================================================

class TimerThread implements Runnable
{

    Voronize v;
    VPanel vp;

    TimerThread (Voronize v, VPanel vp)
    {
        this.v = v;
        this.vp = vp;
    }

    public void run()
    {
        long ltime;
        double csecs;

        try
        {
            java.text.DecimalFormat dFormat = new java.text.DecimalFormat("###.###");

            while (true)
            {
                ltime = System.currentTimeMillis();
                Thread.sleep(250);
                int turn = vp.tc.whosTurn();
                if (turn != 0 && vp.NumTurns != 0)
                {
                    csecs = (double)(System.currentTimeMillis() - ltime) / 1000.0;

                    if (vp.Times[turn-1] - csecs >= 0)
                   {
                       vp.Times[turn-1] -= csecs;
                       v.TimeLabels[turn-1].setText("[TIME]:  "
                           + dFormat.format(vp.Times[turn - 1]));
                   }
                }
            }
        }

        catch(Exception e)
        {
            System.out.println(e);
        }
    }
}

//============================================================================

class netServer
{

    Semaphore turnSemaphore = new Semaphore(1);
    int NextPlayerNumber = 1;
    Voronize v;
    VPanel vp;
    String sPort;
    int MaxPlayers;
    Socket PlayerSockets[];

    public netServer (String sPort, Voronize v, VPanel vp, int MaxPlayers)
    {
        this.v = v;
        this.vp = vp;
        this.sPort = sPort;
        this.MaxPlayers = MaxPlayers;
        this.PlayerSockets = new Socket[MaxPlayers];
    }

    public void go()
    {

        int port;
        ServerSocket server_socket;

        this.v = v;
        this.vp = vp;

        try {
            port = Integer.parseInt(sPort);
        }
        catch (Exception e) {
            port = 20000;
        }

        try
        {

            server_socket = new ServerSocket(port);
            System.out.println("netServer running on port " +
                               server_socket.getLocalPort());

            // server infinite loop
            while (true)
            {
                Socket socket = server_socket.accept();
                System.out.println ("connection " + vp.gs.check());

                if ((vp.gs.check() == false) && (NextPlayerNumber < MaxPlayers+1))
                {
                    System.out.println("New connection accepted " +
                                       socket.getInetAddress() +
                                       ":" + socket.getPort());

                    // Construct handler to process the request message.
                    try {

                        PlayerSockets[NextPlayerNumber - 1] = socket;
                        netRequestHandler request = new netRequestHandler(
                            socket, this);

                        vp.setNumPlayers(NextPlayerNumber);

                        NextPlayerNumber++;

                        // Create a new thread to process the request.
                        Thread thread = new Thread(request);

                        // Start the thread.
                        thread.start();
                    }

                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                else socket.close();
            }
        }

        catch (IOException e) {
            System.out.println(e);
        }
    }

}

//============================================================================

class netRequestHandler implements Runnable
{
    final static String CRLF = "\r\n";
    Socket socket;
    InputStream input;
    OutputStream output;
    BufferedReader br;
    netServer parent;
    int PlayerNumber;

    // Constructor
    public netRequestHandler(Socket socket, netServer parent) throws Exception
    {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.parent = parent;
        this.PlayerNumber = parent.NextPlayerNumber;
    }

    // Implement the run() method of the Runnable interface.
    public void run()
    {
        try
        {
            processRequest ();
            //System.out.println("Returning from netRequestHandler");
            return;
        }

        catch(Exception e)
        {
            System.out.println(e);
        }
    }

    private void processRequest() throws Exception
    {
        Random r = new Random();

        parent.vp.gs.waitForGameStart ();

        /*
        String status = (parent.v.BoardSize - 2)  + " " +
            parent.vp.NumTurns / parent.vp.NumPlayers + " " +
            parent.vp.NumPlayers + " " + PlayerNumber + "\n";
         */

        String status = (parent.v.BoardSize)  + " " +
            parent.vp.NumTurns / parent.vp.NumPlayers + " " +
            parent.vp.NumPlayers + " " + PlayerNumber + "\n";

        output.write(status.getBytes());

        parent.vp.rc.inc ();
        parent.vp.rc.waitReady();

        while (true) {
            System.out.println(PlayerNumber + ": Waiting for turn");
            parent.vp.tc.waitTurn(PlayerNumber);
            //parent.turnSemaphore.down();

            int x = 0;
            int y = 0;

            if (parent.vp.NumTurns != 0) {
                System.out.println(PlayerNumber + " - My Turn");

                while (br.ready())
                    br.readLine();

                status = "YOURTURN\n";
                System.out.println(PlayerNumber + " - Sending " + status);
                output.write(status.getBytes());

                try
                {

                    String line = br.readLine();
                    StringTokenizer s = new StringTokenizer(line);
                    x = Integer.parseInt(s.nextToken());
                    y = Integer.parseInt(s.nextToken());

                    /*
                    x = r.nextInt(400);
                    y = r.nextInt(400);
                    Thread.sleep (1000);
                        */

                    Point p = new Point(x, y);

                    for (int i = 0; i < parent.vp.NumPlayers; i++)
                    {
                        if (i != PlayerNumber - 1)
                        {
                            try
                            {
                                OutputStream o = parent.PlayerSockets[i].
                                    getOutputStream();
                                status = p.x + " " + p.y + " " + PlayerNumber +
                                    "\n";
                                o.write(status.getBytes());
                            }
                            catch (Exception ex)
                            {
                                System.out.println("Error writing move to player!");
                                System.out.println("Probably a human error.");
                                System.out.println(ex);
                            }

                        }
                    }

                    //System.out.println (PlayerNumber + ": Making move " + p.x + " " + p.y);
                    //if (x < 0 || x >= parent.v.BoardSize-2 || y < 0 ||
                    if (x < 0 || x >= parent.v.BoardSize || y < 0 ||
                        y >= parent.v.BoardSize)
                        System.out.println("Invalid move! " + x + " " + y);
                    else
                    {
                        parent.vp.makeMove(p, parent.v, parent.vp);
                    }
                }

                catch (Exception e) {
                    System.out.println("Invalid move?");
                    System.out.println(e);
                }

                //parent.turnSemaphore.up();
            }

            else {
                Point p = new Point(0, 0);
                //System.out.println (PlayerNumber + ": Making move " + p.x + " " + p.y);
                parent.vp.makeMove(p, parent.v, parent.vp);

                if (PlayerNumber == parent.vp.Winner)
                    status = "WIN\n";
                else
                    status = "LOSE\n";

                output.write(status.getBytes());

                try {
                    output.close();
                    br.close();
                    socket.close();
                }
                catch (Exception e) {}

                return;
            }
        }
}

}