/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Voronize {
    final double FUDGE = 1.0E-7;
    public final int W;
    public final int H;
    public final PointDouble UL;
    public final PointDouble UR;
    public final PointDouble LL;
    public final PointDouble LR;
    public Vector points;
    public Vector ppolys;
    public static int MaxPlayers = 25;
    public static int BoardSize = 400;
    public static netServer ns;
    public static VPanel vp;
    public static Choice turnsChoice;
    public static Choice timeChoice;
    public static Choice humansChoice;
    public static Frame ScoreBoardFrame;
    public static Panel ScoreBoard;
    public static Label[] ScoreLabels;
    public static Label[] TimeLabels;
    int count;

    public Voronize(int n, int n2) {
        this.W = n;
        this.H = n2;
        this.UL = new PointDouble(0.0, 0.0);
        this.UR = new PointDouble(this.W - 1, 0.0);
        this.LL = new PointDouble(0.0, this.H - 1);
        this.LR = new PointDouble(this.W - 1, this.H - 1);
        this.clear();
    }

    public void clear() {
        this.points = new Vector();
        this.ppolys = new Vector();
    }

    public Vector getPoints() {
        return this.points;
    }

    public Vector getPPolys() {
        return this.ppolys;
    }

    public void set(Vector vector) {
        int n;
        this.count = 0;
        this.points = vector;
        this.ppolys = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            this.ppolys.addElement(new PolarPoly());
        }
        for (n = 0; n < vector.size(); ++n) {
            VLine[] vLineArray = this.getBisectors(n);
            this.addPoint(n, vLineArray, false);
        }
    }

    public double[] getHeatMap() {
        Point point = new Point(0, 0);
        double[] dArray = new double[this.W * this.H];
        for (int i = 0; i < this.H; ++i) {
            System.out.println("y: " + i);
            for (int j = 0; j < this.W; ++j) {
                point.x = j;
                point.y = i;
                dArray[i * this.W + j] = this.points.contains(point) ? 0.0 : this.testPoint(point).area();
            }
        }
        return dArray;
    }

    public PolarPoly testPoint(Point point) {
        PolarPoly polarPoly = new PolarPoly();
        VLine[] vLineArray = this.getBisectors(point);
        this.getPoly(-1, polarPoly, point, 0, vLineArray, true);
        return polarPoly;
    }

    public void addPoint(Point point) {
        this.points.addElement(point);
        this.ppolys.addElement(new PolarPoly());
        VLine[] vLineArray = this.getBisectors(this.points.size() - 1);
        this.addPoint(this.points.size() - 1, vLineArray, true);
    }

    public void addPoint(int n, VLine[] vLineArray, boolean bl) {
        int n2;
        if (bl) {
            for (n2 = 0; n2 < vLineArray.length - 4; ++n2) {
                this.prune(n2, vLineArray[n2]);
            }
        }
        n2 = bl ? 0 : n + 1;
        this.getPoly(n, (PolarPoly)this.ppolys.elementAt(n), (Point)this.points.elementAt(n), n2, vLineArray, false);
    }

    private void getPoly(int n, PolarPoly polarPoly, Point point, int n2, VLine[] vLineArray, boolean bl) {
        for (int i = n2; i < vLineArray.length - 1; ++i) {
            for (int j = i + 1; j < vLineArray.length; ++j) {
                VLine vLine;
                PointDouble pointDouble = vLineArray[i].getIntersection(vLineArray[j]);
                if (pointDouble == null || !this.isGood(n, i, j, vLine = new VLine(point.x, point.y, pointDouble.x, pointDouble.y), pointDouble, vLineArray, point)) continue;
                polarPoly.addPoint(pointDouble);
                if (bl) continue;
                ++this.count;
                if (i < vLineArray.length - 4) {
                    ((PolarPoly)this.ppolys.elementAt(i)).addPoint(pointDouble);
                }
                if (j >= vLineArray.length - 4) continue;
                ((PolarPoly)this.ppolys.elementAt(j)).addPoint(pointDouble);
            }
        }
    }

    private boolean isGood(int n, int n2, int n3, VLine vLine, PointDouble pointDouble, VLine[] vLineArray, Point point) {
        boolean bl = true;
        int n4 = 0;
        do {
            PointDouble pointDouble2;
            if ((n4 == n2 || n4 == n3 || n4 == n) && n4 < vLineArray.length - 4 || (pointDouble2 = vLine.getIntersection(vLineArray[n4])) == null || !(Math.min((double)point.x, pointDouble.x) <= pointDouble2.x) || !(pointDouble2.x <= Math.max((double)point.x, pointDouble.x)) || !(Math.min((double)point.y, pointDouble.y) <= pointDouble2.y) || !(pointDouble2.y <= Math.max((double)point.y, pointDouble.y)) || !(Math.abs((double)point.x - pointDouble2.x) > 1.0E-7) && !(Math.abs((double)point.y - pointDouble2.y) > 1.0E-7) || !(Math.abs(pointDouble.x - pointDouble2.x) > 1.0E-7) && !(Math.abs(pointDouble.y - pointDouble2.y) > 1.0E-7)) continue;
            bl = false;
        } while (bl && ++n4 < vLineArray.length);
        return bl;
    }

    private void prune(int n, VLine vLine) {
        PolarPoly polarPoly = (PolarPoly)this.ppolys.elementAt(n);
        Point point = (Point)this.points.elementAt(n);
        double d = vLine.eval(point);
        int n2 = polarPoly.getSize();
        for (int i = n2 - 1; i >= 0; --i) {
            PointDouble pointDouble = polarPoly.getPoint(i);
            double d2 = vLine.eval(pointDouble);
            if (Math.abs(d2) < 0.01) {
                d2 = 0.0;
            }
            if (!(d2 * d < 0.0)) continue;
            polarPoly.removePoint(i);
        }
    }

    private VLine[] getBisectors(int n) {
        VLine[] vLineArray = new VLine[this.points.size() + 3];
        Point point = (Point)this.points.elementAt(n);
        int n2 = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            if (i == n) continue;
            vLineArray[n2++] = this.getPerpBisect(point, (Point)this.points.elementAt(i));
        }
        vLineArray[n2++] = new VLine(this.UL, this.UR);
        vLineArray[n2++] = new VLine(this.UR, this.LR);
        vLineArray[n2++] = new VLine(this.LR, this.LL);
        vLineArray[n2++] = new VLine(this.LL, this.UL);
        return vLineArray;
    }

    public VLine[] getBisectors(Point point) {
        VLine[] vLineArray = new VLine[this.points.size() + 4];
        for (int i = 0; i < this.points.size(); ++i) {
            vLineArray[i] = this.getPerpBisect(point, (Point)this.points.elementAt(i));
        }
        vLineArray[i++] = new VLine(this.UL, this.UR);
        vLineArray[i++] = new VLine(this.UR, this.LR);
        vLineArray[i++] = new VLine(this.LR, this.LL);
        vLineArray[i++] = new VLine(this.LL, this.UL);
        return vLineArray;
    }

    private VLine getPerpBisect(PointDouble pointDouble, PointDouble pointDouble2) {
        PointDouble pointDouble3 = new PointDouble((pointDouble.x + pointDouble2.x) / 2.0, (pointDouble.y + pointDouble2.y) / 2.0);
        PointDouble pointDouble4 = new PointDouble(-(pointDouble.y - pointDouble3.y) + pointDouble3.x, pointDouble.x - pointDouble3.x + pointDouble3.y);
        PointDouble pointDouble5 = new PointDouble(-(pointDouble2.y - pointDouble3.y) + pointDouble3.x, pointDouble2.x - pointDouble3.x + pointDouble3.y);
        return new VLine(pointDouble4, pointDouble5);
    }

    private VLine getPerpBisect(Point point, Point point2) {
        return this.getPerpBisect(new PointDouble(point.x, point.y), new PointDouble(point2.x, point2.y));
    }

    private static Vector readPoints(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Vector<Point> vector = new Vector<Point>();
        while ((string2 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            vector.addElement(new Point(n, n2));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        if (stringArray.length > 1) {
            System.err.println("usage: Voronize [port]");
            System.exit(1);
        }
        Voronize voronize = new Voronize(BoardSize + 2, BoardSize + 2);
        Frame frame = new Frame("Voronoi Competition");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        vp = new VPanel(voronize);
        vp.setPreferredSize(new Dimension(voronize.W, voronize.H));
        Color[] colorArray = new Color[]{new Color(255, 200, 200), new Color(200, 200, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 255, 0), new Color(150, 0, 0), new Color(0, 150, 0)};
        MaxPlayers = colorArray.length;
        vp.setColors(colorArray);
        frame.add((Component)vp, "Center");
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new GridLayout(8, 1));
        ButAct butAct = new ButAct(voronize, vp);
        Button button = new Button("Reset");
        panel.add(button);
        button.addActionListener(butAct);
        Button button2 = new Button("Start");
        panel.add(button2);
        button2.addActionListener(butAct);
        ChoiceListener choiceListener = new ChoiceListener(voronize, vp);
        Label label = new Label("Human Players:");
        panel.add(label);
        panel.add(humansChoice);
        for (n = 0; n <= 5; ++n) {
            humansChoice.add(Integer.toString(n));
        }
        humansChoice.select("0");
        humansChoice.addItemListener(choiceListener);
        label = new Label("Turns:");
        panel.add(label);
        panel.add(turnsChoice);
        for (n = 1; n <= 25; ++n) {
            turnsChoice.add(Integer.toString(n));
        }
        turnsChoice.select("7");
        turnsChoice.addItemListener(choiceListener);
        Voronize.vp.StartTurns = 7;
        label = new Label("Player Time Limit:");
        panel.add(label);
        panel.add(timeChoice);
        for (n = 0; n <= 1800; n += 30) {
            timeChoice.add(Integer.toString(n));
        }
        timeChoice.select("180");
        timeChoice.addItemListener(choiceListener);
        Voronize.vp.PlayerTimeLimit = 180;
        frame.add((Component)panel, "West");
        frame.pack();
        frame.setVisible(true);
        GridLayout gridLayout = new GridLayout(10, 2);
        gridLayout.setHgap(5);
        gridLayout.setVgap(5);
        ScoreBoard.setLayout(gridLayout);
        ScoreLabels = new Label[colorArray.length];
        TimeLabels = new Label[colorArray.length];
        Font font = new Font("Dialog", 0, 20);
        for (int i = 0; i < colorArray.length; ++i) {
            object2 = new Label("Player " + (i + 1) + ":  ");
            object = new Label("TIME:  ");
            ((Component)object2).setFont(font);
            ((Component)object2).setBackground(colorArray[i]);
            ScoreBoard.add((Component)object2);
            Voronize.ScoreLabels[i] = object2;
            ((Component)object).setFont(font);
            ((Component)object).setBackground(colorArray[i]);
            ScoreBoard.add((Component)object);
            Voronize.TimeLabels[i] = object;
        }
        ScoreBoardFrame.setSize(400, 400);
        ScoreBoardFrame.add(ScoreBoard);
        ScoreBoardFrame.setVisible(true);
        TimerThread timerThread = new TimerThread(voronize, vp);
        object2 = new Thread(timerThread);
        ((Thread)object2).start();
        object = new String();
        if (stringArray.length == 1) {
            object = stringArray[0];
        }
        ns = new netServer((String)object, voronize, vp, colorArray.length);
        vp.resetGame();
        ns.go();
    }

    static {
        turnsChoice = new Choice();
        timeChoice = new Choice();
        humansChoice = new Choice();
        ScoreBoardFrame = new Frame("Score Board");
        ScoreBoard = new Panel();
    }
}

