# The master program gets the configurations as a text file, with one package
# per line in the format 
# major.minor versions in ascending order.
# Packages are in their priority order from highest to lowest.
# The algorithm first sends to clients the maximum of each major release
# then if release x works but x+1 doesn't, test the ones in between. 
# The implicit assumption is that if major release x+1 with the max
# of the minor version doesn't work, then no minor version of major release
# x+2 will work.
# This is not really justifiable I don't think but is good for quick and
# dirty. The manager also keeps track of already tried configurations,
# so nothing is tried again.
# The call to each client will be  of the form ['4.5', '3.9', '1.3'] 
# that is a configuration that checkworks will test
# The output will be the highest major configurations found and then the
# highest overall.

# For the sake of simulation the checkworks function 
# will have a probability
# for each configuration to determine whether it is good or not.
# Of course, this will be a real test eventually.

# If a configuration has failed for one slave, no other slave 
# gets that configuration.
# If a configuration succeeds for one or more slaves, the master
# keeps track of that information in configstats.

# configstat maps configurations to a vector that is as long as 
# the number of slaves.
# For a particular configuration c, configstat[c] is set to all 0s.
# If slave i succeeds with configuration c, then the ith
# entry of configstat[c] is set to +1.
# If slave i fails with configuration c, then the ith
# entry of configstat[c] is set to -1.
# Configuration c succeeds if the min value is 1. It fails if the min value
# is -1. 
import zmq, time
import copy

context = zmq.Context()
socket = context.socket(zmq.REP)
socket.bind("tcp://*:50008")

# FUNCTIONS


# generate the cross-product of the configurations in descending order
# if majorflag = True then do it only for the last minor of each major 
def genconfigs(packageversions, majorflag):
  if majorflag == True:
    packageversions = slim(packageversions)
  elif  0 < len(majorconfig):
    # find highest packages of the major that didn't work
    # and eliminate all above that
    # So if major version 2 of a pacakge worked but 3 did not, then eliminate
    # everything above 3. 
    # Otherwise try everything (don't filter at all).
    packageversions = slimmajor(packageversions)
  return mycrossproduct(packageversions)


# return the cross product in descending order
def mycrossproduct(packageversions):
  reversed = packageversions[::-1]
  currentcross = [[x] for x in reversed[0][::-1]]
  i = 1
  while (i < len(reversed)):
    row = reversed[i][::-1]
    out = []
    for r in row:
      for c in currentcross:
        out.append([r]+c)
    currentcross = copy.deepcopy(out)
    i+= 1
  return currentcross
    

# slimmajor for each supply-constant mini-series, this will take the
# minimum minor version.
# For each demand-constant mini-series, it will take the last one.
# ??? Still to be done
def slimmajor(packageversions):
  out = []
  i = 0
  while (i < len(packageversions)):
    p = packageversions[i]
    goodmajor = majorconfig[i]
    new = []
    j = 0
    while  (j < len(p)) and (p[j] != goodmajor):
      j+= 1
    majornum = int(((p[j]).split('.'))[0])
    while  (j < len(p)): 
      x = int(((p[j]).split('.'))[0])
      if (x < majornum+2):
        new.append(p[j])
      j+=1
    out.append(new)
    i+= 1
  # print 'Package versions to handle minor (second phase): ', out
  return out
    

# take only the latest minors of each major
def slim(packageversions):
  out = []
  for  p in packageversions:
    new = findhighestperpackage(p)
    out.append(new)
  return out

# find the highest minor for each major per package
def findhighestperpackage(line):
  out = [line[0]]
  i = 1
  currentmajornum = -1
  last = ''
  lasttakenflag = False
  while (i < len(line)):
    x = line[i]
    pv = x.split(".")
    if (0 < len(last)) and (pv[0] != currentmajornum):
      out.append(last)
      if i == ((len(line)) - 1):
        lasttakenflag = True
    currentmajornum = pv[0]
    last = x
    i+= 1
  if lasttakenflag == False:
    out.append(last)
  return out

  

# find work for this slave from 0. We always start from 0 because we'll find the
# right index.
# Pass by all configs that have a -1 (indicating failure).
# If they all have failed then there is nothing good
def requestwork(slaveid, configindex):
   configindex = 0 # ignore the index from the slave in fact
   i = configindex
   c = configs[i]
   string_c = '_'.join(c) 
   if (configstat[string_c][slaveid] == 1): # this was good for us
     if min(configstat[string_c]) == 1:
       # print "Success with: ", configs[i]
       return(str(i) + ' ' + string_c + ' Success')
     if min(configstat[string_c]) == 0:
       # print "Slave ", slaveid, " has had success with configuration ", c, " and will wait "
       return(str(i) + ' ' + string_c + ' Already_done')
   i = configindex + 1
   if i < len(configs): 
     c = (configs[i])
   while(i < len(configs)):
     c = (configs[i])
     string_c = '_'.join(c) 
     if 0 == min(configstat[string_c]): # still unknown
       return(str(i) + ' ' + string_c + ' Not_yet')
     if 1 == min(configstat[string_c]): # still unknown
       return(str(i) + ' ' + string_c + ' Success')
     i+= 1
   return(str(i) + ' ' +  'Non-existentconfig'  + ' Tried_everything')

# if the slave succeeded at this config, then set the appropriate element
# of configstat vector to status (and check whether that is a good config). 
# 1 will be a success status and -1 a failure status.
def updatestatus(slaveid, configindex, status):
  global configstat, majorconfig
  c = (configs[configindex])
  string_c = '_'.join(c)
  configstat[string_c][slaveid] = status
  if 1 == min(configstat[string_c]):
    if (0 == len(majorconfig)):
      majorconfig = c
    # print "configuration: ", c , " works."
    return (["Success", c])
  return (["Keep_going", c])
   
  
# EXECUTION

numslaves = 1  # the number of clients
i = 0
a = [0] * numslaves
print "Number of clients (systems) is: ", a


# master has a list of all connections
fileicareabout = open("packageversions","r")
pv = fileicareabout.read().splitlines()
fileicareabout.close()
packageversions = []
for line in pv:
 x = line.split(" ") 
 packageversions.append(x)

# all possible configurations
configs = mycrossproduct(packageversions)
 
configstat = {}
for c in configs:
  string_c = '_'.join(c)
  configstat[string_c] = copy.deepcopy(a)

# configurations start out with all 0s and then the 0 for slave i
# either a -1 (if fail for slave i) or 1 (if succeed for slave i.

majorFlag = True
majorconfig = [] # configuration that we have found when searching for majors
 # eliminate all lesser versions and all versions 
 # above one major version greater
 # e.g. if we have version 3.99 for package i in a good config, then
 # use all versions that begin with 4 for package i (if any) and that's it.
 # keep 3.99
 # this is filled only if majorconfig finds something.


for i in range(2):
  configs = genconfigs(packageversions, majorFlag)
  if majorFlag == True:
    print 'Here are the major configurations to try: ', configs
  if majorFlag == False:
    print 'Here are the minor configurations to try: ', configs
  while True:
    data = socket.recv()
    # print 'data are ', data
    if not data: break
    fields = data.split(" ") 
    # print "fields are: ", fields
    # format is slave number, opcode, args
    # opcodes can be 'requestwork' with argument last configindex tried
    #    -- response can be a new config or 'done'
    # 'updatestatus' with argument configindex and succeed(1) or fail(0) 
    numpart= ((fields[0]).split(":"))[1]
    if fields[1] == 'requestwork':
       ret = requestwork(int(numpart), int(fields[2]))
       # print 'ret from requestwork: ', ret
       socket.send("%s " % (ret))
    if fields[1] == 'updatestatus':
       ret = updatestatus(int(numpart), int(fields[2]), int(fields[3]))
       c = ret[1]
       # print 'For majorFlag = ', majorFlag, ' configuration = ', c,  'ret from updatestatus: ', ret[0]
       if (ret[0] == 'Success') and (majorFlag == True):
          socket.send("%s " % (ret[0]))
          print 'Successful configuration for major versions: ', c
          print "~~~~~~~~"
          break 
       elif (ret[0] == 'Success') and (majorFlag == False):
          print 'Successful configuration for minor versions: ', c
          socket.send("%s " % (ret[0]))
          break 
       else:
          # print "return value: ", ret
          # print "~~~~~~~~"
          socket.send("%s " % (ret[0]))
  majorFlag = False
