# -*- coding: utf-8 -*-
import subprocess # To call RScript

class RPlotterOps(object):

  def __init__(self):
    self.r_bindir = 'recog_stoch_sim'
    self.r_plotter_bin = 'nupack_pair_plots.R'
    self.r_temperature_plot_bin = 'nupack_analysis_plots.R'
    self.rscript = 'Rscript'

  def plot_pairs(self, design_filename):
    output = subprocess.check_output([self.rscript,
                                      self.r_bindir + '/' + self.r_plotter_bin,
                                      design_filename])


  def plot_temperature(self, design_filename):
    output = subprocess.check_output([self.rscript,
                                      self.r_bindir + '/' + self.r_temperature_plot_bin,
                                      design_filename])


