N <- 4 # Number of possible strands to try matching with the target

C <- rep(5.0, N + 1) # Code stack concentrations
A <- rep(10.0, N) # Target concentration 
Tick <- rep(1.0, N) # Tick strand concentrations
Tock <- rep(1.0, N) # Tock strand concentrations
n <- 1:N # Instructions at the i'th code stack

h_gamma_alpha <- rep(0.0, N) # yield constant for gate i/target hybridizaiton

run_sim <- function(N,C,A,Tick,Tock,n,h_gamma_alpha) {
  D <- rep(0, N + 1) # Strands of the i'th gate released at time step i
  M <- rep(0, N + 1) # Strands reacting with the target at time step i
  F <- rep(0, N + 1) # Strands flourescing at time step i
  
  h_tick_tock <- 0.99 # yield constant for tick/tock hybridization
  h_gamma_gamma <- rep(1.0, N) # yield constant for gate i/anti-gate i hybridization
  
  #h_gamma_alpha[1] <- 1.0
  
  r <- 0.5 # max reconstruction of flourescence
  
  D[1] <- Tick[1] * C[1]* (( (1 - (h_tick_tock**(n[1] + 1))) / (1 - h_tick_tock) ) - 1)
  M[1] <- D[1] * ( (A[1] * h_gamma_alpha[1]) / (A[1] * h_gamma_alpha[1] + C[2]) )
  F[1] <- D[1] * ( (C[2] * h_gamma_gamma[1]) / (A[1] + C[2]) )
  A[2:length(A)] <- A[2] - M[1]
  
  for (i in seq(2, N)) {
    D[i] <- F[i-1] * Tick[i] * (( (1 - (h_tick_tock**(n[i] + 1))) / (1 - h_tick_tock) ) - 1)
    M[i] <- D[i] * ( (A[i] * h_gamma_alpha[i]) / (A[i] * h_gamma_alpha[i] + C[i+1]) ) 
    F[i] <- D[i] * ( (C[i+1] * h_gamma_gamma[i]) / (A[i] + C[i+1]) )
    A[(i+1):length(A)] <- A[i+1] - M[i]
  }
  # Flourescence degrades from t to t+1 at approximately (C/(A+C)).
  F
}

