import java.awt.*; 
import java.awt.event.*; 
import java.applet.*;


public class Superply extends Applet implements ActionListener, MouseListener { 
     /**
	 * 
	 */
	private static final long serialVersionUID = 1L; 
     TextField player1Field;
     TextField player2Field;
     Button enterButton; 
     Button start;
     Button askHint;
     Button infoOn;
     Button infoOff;
     
     private String [] player = new String[3];
     
     private boolean gameInProgress = false;
     
     private int currPlayer = 2;
     //private boolean moveInProgress = true;
     private int xPos;
     private int yPos;
     private String resultMessage = null;

     private String hint = "";
     private Board board = new Board();
     private boolean gameOver = false;
     private boolean hintIsOn = false;
     private boolean infoIsOn = true;
     
     public void init()  
     { 
    	 this.setSize(580, 530);
          //setLayout(new FlowLayout());
          enterButton = new Button("Enter"); 
          //enterButton.se
          player1Field = new TextField("Player 1");
          //player1Field.setBounds(100, 50, 120, 40);
          player2Field = new TextField("Player 2");
          //player2Field.setBounds(100, 100, 120, 40);
          enterButton.setBounds(100, 150, 120, 40);
          enterButton.addActionListener(this); 
          player1Field.addActionListener(this);
          player2Field.addActionListener(this);
          add(player1Field); 
          add(player2Field);
          add(enterButton); 
          board = new Board();
          //moveInProgress = false;
          currPlayer = 2;
          gameOver = false;
     }
     

     public void actionPerformed(ActionEvent act) { 
    	 if (act.getSource() == enterButton) {
    		 player[1] = player1Field.getText();
    		 player[2] = player2Field.getText();
    		 gameInProgress = true;
    		 remove(player1Field);
    		 remove(player2Field);
    		 remove(enterButton);		
    		 System.out.println("here ");
    		 start = new Button("Restart");
    		 start.setBounds(420,100, 100,40);
    		 start.addActionListener(this);
    		 add(start);
    		 askHint = new Button("hint");
    		 askHint.setBounds(420, 160, 100, 40);
    		 askHint.addActionListener(this);
    		 add(askHint);
    		 infoOn = new Button("Info On");
    		 infoOn.setBounds(420, 220, 100, 40);
    		 infoOn.addActionListener(this);
    		 //add(infoOn);
    		 infoOff = new Button("Info Off");
    		 infoOff.setBounds(420, 220, 100, 40);
    		 infoOff.addActionListener(this);
    		 add(infoOff);
    		 addMouseListener(this);
    		 restart();
    		 System.out.println("names set to "+ player[1] + " and " + player[2]);
    	 }
		 //infoIsOn = false;
		 //hintIsOn = false;
    	 if (act.getSource() == start) {
    		 restart();
    	 }
    	 if (act.getSource() == askHint) {
    		hintIsOn = !hintIsOn;
       	 	repaint();
    		//hintIsOn = false;
    	 }
    	 if (act.getSource() == infoOff) {
    		 //System.out.println("got here");
    		 infoIsOn = false;
    		 remove(infoOff);
    		 add(infoOn);
        	 repaint();
    	 }    	 
    	 if (act.getSource() == infoOn) {
    		 //System.out.println("got here");
    		 infoIsOn = true;
    		 remove(infoOn);
    		 add(infoOff);
        	 repaint();
    	 }
     }
     
     private void restart() {
         board = new Board();
         //moveInProgress = false;
         currPlayer = 2;
         gameOver = false;
		 currPlayer = 3 - currPlayer;
		 hint = board.generateNextHint();
		 hintIsOn = false;
		 resultMessage = "";
		 repaint();
     }
     
     public void paint(Graphics g) {  
    	 if (!gameInProgress) {
    		 return;
    	 }
    	 
    	 start.setBounds(420,170, 100,40);
		 askHint.setBounds(420, 230, 100, 40);
		 infoOn.setBounds(420, 290, 100, 40);
		 infoOff.setBounds(420, 290, 100, 40);
		 //enterButton.setBounds(100, 150, 120, 40);
		 
    	 for (int i=1; i<11; i++) {
    		 g.drawString("" + i, 60, 30*i + 130 );
    		 g.drawString("" + i, 30*i + 60, 138 );
    	 } 
    	 
    	 for (int i=0; i<10; i++) {
    		 for (int j=0; j<10; j++) {
    			 switch (board.getPlayer(i, j)) {
    			 case 1: g.setColor(Color.RED); break;
    			 case 2: g.setColor(Color.BLUE); break;
    			 case 4: 
    				 if (hintIsOn) {
    					 g.setColor(Color.GREEN);
    					 break;
    				 } 
    			 default: g.setColor(Color.GRAY);
    			 }
    			 g.fillRect(80 + i*30, 140 + j*30, 28, 28);
    			 if (board.getPlayer(i, j) == 1 || board.getPlayer(i, j) == 2) {
    				 g.setColor(Color.WHITE);
    				 g.drawString("" + (i+1)*(j+1), 87 + i*30, 157 + j*30);
    			 }
    		 }
    	 }
    	 
		 Font font = new Font(Font.DIALOG, Font.BOLD, 14);
		 g.setFont(font);
		 
		 if (infoIsOn)  {
	    	 g.setColor(Color.RED);
			 g.drawString(player[1] + ", try to connect the upper side to the lower side with red squares", 30, 500);
			 g.setColor(Color.BLUE);
			 g.drawString(player[2] + ", try to connect the right side to the left side with blue squares", 30, 520);
		 }
    	 if (currPlayer == 1) {
    		 g.setColor(Color.RED);
    	 } else {
    		 g.setColor(Color.BLUE);
    	 }
    	 if (gameOver) {
    		 font = new Font(Font.DIALOG, Font.BOLD, 24);
    		 g.setFont(font);
    		 g.drawString("Winner is " + player[currPlayer] + "!!!", 100, 70);
    	 } else {
	    	 g.drawString(player[currPlayer] + "'s turn",100,35);
	    	 g.drawString(hint ,100, 57);
	    	 g.setColor(Color.BLACK);
	    	 g.drawString(resultMessage, 100, 79);
    	 }
    	 
    	 
     }


	@Override
	public void mouseClicked(MouseEvent e) {
		System.out.println("mouse clicked");
		hintIsOn = false;
		//infoIsOn = false;
		repaint();
		//moveInProgress = true;
		xPos = e.getX();
		yPos = e.getY();
		if (xPos<380 && xPos>80 && yPos>140 && yPos<440 && !gameOver) {
			int result = board.acceptMove((xPos-80)/30 , (yPos - 140)/30, currPlayer);
			switch (result) {
			case Protocol.INVALID_MOVE: 
				resultMessage = " Invalid Move!"; 
				break;
			case Protocol.BAD_GUESS :
				resultMessage = player[currPlayer] + " had bad guess!";
				currPlayer = 3 - currPlayer;
				System.out.println("switch user");
				hint = board.generateNextHint().toString();
				repaint();
				break;
			case Protocol.SUCCESS : 
				if (board.isTherePath(currPlayer)) {
					gameOver = true;
					System.out.println("game over");
				} else {
					resultMessage = player[currPlayer] + " colored the square";
					currPlayer = 3 - currPlayer;
					hint = board.generateNextHint().toString();
				}
				repaint();
				break;
			default:
			}
		}
	}


	@Override
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
} 


