package superply.math;


/*
 * Created on Nov 21, 2004
 */

/**
 * @author Chris Quackenbush
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HintChooser {
	String[] hints = {
		"odd",
		"even",
		"between 0 18",
		"between 18 81",
		"contains 4",
		"odd",
		"even",
		"between 0 16",
		"between 16 36",
		"contains 2",
		"odd",
		"even",
		"between 12 42",
		"between 20 54",
		"contains 5",
		"odd",
		"even",
		"between 8 20",
		"between 18 30",
		"contains 1",
	};
	boolean random = true;
	int counter = 0;
	HintChecker hc;
	/**
	 * @param hintType "random" or "deterministic"
	 */
	public HintChooser(String hintType, HintChecker hintC) {
		if(hintType.equals("deterministic"))
			random = false;
		hc = hintC;
	}

	/**
	 * @return the next hint
	 */
	public String next() {
		do{
			if(random){
				counter = (int)(hints.length*Math.random());
			}else{
				counter++;counter%=hints.length;
			}
		}while(hc.hintCells[counter].size()<=0);
		return hints[counter];
	}

	/**
	 * @return the current hint
	 */
	public String get() {
		return hints[counter];
	}
}
