package superply;

import java.awt.Point;

import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
/*
 * Created on Oct 12, 2004
 */

/**
 * @author David Kaplin and Chris Quackenbush
 */
public class SPMoveAnalyzer extends MoveAnalyzer {
    SPSystemAnalyzer castedParent;
    public SPMoveAnalyzer(SPSystemAnalyzer vs){
        parent = vs;
        castedParent = vs;
    }
    /** 
     * @see heurgame.analysis.MoveAnalyzer#evaluateMove(java.lang.String, heurgame.PlayerProxy.PlayerInfo)
     */
    public String evaluateMove(String textMove, PlayerToken owner,long time) {
        if (textMove==null){
            System.out.println("Unexpected Disconnection");
            return MoveAnalyzer.MOVE_DISQUALIFIED+" Empty Move?!";
        }
        String parts[] = textMove.split(" ");
        Point p = new Point(Integer.parseInt(parts[0]),Integer.parseInt(parts[1]));
        long total = castedParent.getTimeRemaining(owner);
        castedParent.addPlayer(owner);
        if (time==0){
            time-=10;
        }
        castedParent.setTimeRemaining(owner,total-time);
        boolean validity =castedParent.makeMove(p,owner); 
		castedParent.goodMove(owner,textMove);
        if (validity){
            return MoveAnalyzer.MOVE_VALID+" Accepted." ; 
        }else{
			return MoveAnalyzer.MOVE_VALID +" Not Accepted."  ;                
        }
    }

}
