package heurgame.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;

/*
 * Created on Oct 29, 2004
 */

/**
 * @author David Kaplin
 *
 * To make a good UI there are plenty of little tricks that work well.
 * This class should encompass them.
 */
public class DisplayUtilities {

    /**
     * Will resize the containing window to make sure it fits this component
     * in.
     * @param c The Component that might need some space
     */
    public static void ensureWindowFits(Component c){
        Container parent = getParentWindow(c);
        java.awt.Frame f = (java.awt.Frame)parent;
        f.pack(); 
    }
    public static Window getParentWindow(Component c){
        Container parent = c.getParent();
        
        while (parent != null && parent.getParent() != null){
            parent = parent.getParent();
        }
        return (Window)parent;
    }
}
