
package heurgame.event.turn;

import java.util.Vector;

/*
 * Created on Nov 21, 2004
 */
 
/**
 * @author Chris Quackenbush
 *
 * In some games, like SuperPly, we do not want to limit the game by the number of turns,
 * but rather continue forever until one player reaches a winning state. This iterator
 * implements that behavior.
 */
public class NoLimitRRIterator extends RoundRobinIterator {
	/**
	 * @return True. By definition this method will always be true.
	 *  
	 * @see heurgame.event.turn.AbstractTurnIterator#hasMore()
	 */
	public boolean hasMore() {
		return true;
	}
	
	/**
	 * Sets or Resets the state of the Iterator
	 * 
	 * @param pTokens		A Vector of Player Tokens in the desired order
	 * @see heurgame.event.turn.RoundRobinIterator#setup()
	 */
	public void setup(Vector pTokens) {
		super.setup(999,pTokens);
	}
	
	
}
