//////////////////////////////////////////
//  Author: Jose Cambronero             //
//	jose.cambronero@cs.nyu.edu          //
//	A quick script to                   //
//  create tables for demo              //
//                                      //
//////////////////////////////////////////

// Options
opts:.Q.opt .z.x;
if[any not `csv`save in key opts; show "Usage: -csv <path-to-csv-folder> -save <path-to-save-q-tables>"; exit 1];

// saving as q binaries for aquery and q
saveToDB:{[path;name;data] show (` sv path,name) set data}

// CSV data paths
CSVPATH:hsym `$first opts`csv;

// paths to write out q serialized objects
SAVEPATH:hsym `$first opts`save;

// subfolders for tables and parameters
tablePath:` sv SAVEPATH,`tables;
paramPath:` sv SAVEPATH,`parameters;


makenodetime:{
  nodetime:("III";enlist ",") 0:` sv CSVPATH,`$"nodetime.csv";
  saveToDB[tablePath;`nodetime;nodetime];
  };

makenodefixed:{
  nodefixed:("IIII";enlist ",") 0:` sv CSVPATH,`$"nodefixed.csv";
  saveToDB[tablePath;`nodefixed;nodefixed];
  };


makeplanttime:{
  planttime:("III";enlist ",") 0:` sv CSVPATH,`$"planttime.csv";
  saveToDB[tablePath;`planttime;planttime];
  };

makeplantfixed:{
  plantfixed:("IIII";enlist ",") 0:` sv CSVPATH,`$"plantfixed.csv";
  saveToDB[tablePath;`plantfixed;plantfixed];
  };

/////////////////////////////////
//                             //
//                             //
// Creating kdb+ databases      //
//                             //	
//                             //
/////////////////////////////////

if[count key ` sv CSVPATH,`$"nodetime.csv"; show "Creating nodetime"; makenodetime[]];
if[count key ` sv CSVPATH,`$"nodefixed.csv"; show "Creating nodefixed"; makenodefixed[]];

if[count key ` sv CSVPATH,`$"planttime.csv"; show "Creating planttime"; makeplanttime[]];
if[count key ` sv CSVPATH,`$"plantfixed.csv"; show "Creating plantfixed"; makeplantfixed[]];

exit 0


