package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

import java.awt.geom.Point2D;

public class QCreateStructure extends PBasicInputEventHandler {
  private QToolFrame frame;
  private int structureType;

  public QCreateStructure(QToolFrame frame) {
    this.frame = frame;
    structureType = Common.THREE_CHAIN;
  }

  public void setStructure(int i) {
    structureType = i;
  }

  public void mouseClicked(PInputEvent event) {
    //System.out.println("click:" + structureType);
    if(!event.isLeftMouseButton())
      return;
    // create new node as composition of ellipse and text
    PLayer edgeLayer = ((PCanvas)(event.getComponent())).getCamera().getLayer(0);
    PLayer nodeLayer = ((PCanvas)(event.getComponent())).getCamera().getLayer(1);
    Point2D pressPoint = event.getPosition();
    switch(structureType) {
    case Common.THREE_CHAIN: {
      QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
      QNode node2 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 60, "n" + Network.nodeCount++);
      QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 120, "n" + Network.nodeCount++);
      QEdge edge1 = new QEdge("e" + Network.edgeCount++);
      edge1.setSource(node1);
      edge1.setTarget(node2);
      node1.addEdge(edge1);
      node2.addEdge(edge1);
      QEdge edge2 = new QEdge("e" + Network.edgeCount++);
      edge2.setSource(node2);
      edge2.setTarget(node3);
      node2.addEdge(edge2);
      node3.addEdge(edge2);
      node1.addToLayer(nodeLayer);
      node2.addToLayer(nodeLayer);
      node3.addToLayer(nodeLayer);
      edgeLayer.addChild(edge1);
      edgeLayer.addChild(edge2);
      edge1.update();
      edge2.update();
      Network.nCount += 3;
      Network.eCount += 2;
      frame.updateStatus();
      break;
    }
    case Common.FEED_FORWARD_LOOP: {
      QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
      QNode node2 = new QNode((float)pressPoint.getX() + 50, (float)pressPoint.getY() + 50, "n" + Network.nodeCount++);
      QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 100, "n" + Network.nodeCount++);
      QEdge edge1 = new QEdge("e" + Network.edgeCount++);
      edge1.setSource(node1);
      edge1.setTarget(node2);
      node1.addEdge(edge1);
      node2.addEdge(edge1);
      QEdge edge2 = new QEdge("e" + Network.edgeCount++);
      edge2.setSource(node2);
      edge2.setTarget(node3);
      node2.addEdge(edge2);
      node3.addEdge(edge2);
      QEdge edge3 = new QEdge("e" + Network.edgeCount++);
      edge3.setSource(node1);
      edge3.setTarget(node3);
      node1.addEdge(edge3);
      node3.addEdge(edge3);
      node1.addToLayer(nodeLayer);
      node2.addToLayer(nodeLayer);
      node3.addToLayer(nodeLayer);
      edgeLayer.addChild(edge1);
      edgeLayer.addChild(edge2);
      edgeLayer.addChild(edge3);
      edge1.update();
      edge2.update();
      edge3.update();
      Network.nCount += 3;
      Network.eCount += 3;
      frame.updateStatus();
      break;
    }
    case Common.BI_FAN: {
      QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
      QNode node2 = new QNode((float)pressPoint.getX() + 70, (float)pressPoint.getY(), "n" + Network.nodeCount++);
      QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 70, "n" + Network.nodeCount++);
      QNode node4 = new QNode((float)pressPoint.getX() + 70, (float)pressPoint.getY() + 70, "n" + Network.nodeCount++);
      QEdge edge1 = new QEdge("e" + Network.edgeCount++);
      edge1.setSource(node1);
      edge1.setTarget(node3);
      node1.addEdge(edge1);
      node3.addEdge(edge1);
      QEdge edge2 = new QEdge("e" + Network.edgeCount++);
      edge2.setSource(node1);
      edge2.setTarget(node4);
      node1.addEdge(edge2);
      node4.addEdge(edge2);
      QEdge edge3 = new QEdge("e" + Network.edgeCount++);
      edge3.setSource(node2);
      edge3.setTarget(node3);
      node2.addEdge(edge3);
      node3.addEdge(edge3);
      QEdge edge4 = new QEdge("e" + Network.edgeCount++);
      edge4.setSource(node2);
      edge4.setTarget(node4);
      node2.addEdge(edge4);
      node4.addEdge(edge4);
      node1.addToLayer(nodeLayer);
      node2.addToLayer(nodeLayer);
      node3.addToLayer(nodeLayer);
      node4.addToLayer(nodeLayer);
      edgeLayer.addChild(edge1);
      edgeLayer.addChild(edge2);
      edgeLayer.addChild(edge3);
      edgeLayer.addChild(edge4);
      edge1.update();
      edge2.update();
      edge3.update();
      edge4.update();
      Network.nCount += 4;
      Network.eCount += 4;
      frame.updateStatus();
      break;
    }
    case Common.BI_PARALLEL: {
      QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
      QNode node2 = new QNode((float)pressPoint.getX() - 50, (float)pressPoint.getY() + 50, "n" + Network.nodeCount++);
      QNode node3 = new QNode((float)pressPoint.getX() + 50, (float)pressPoint.getY() + 50, "n" + Network.nodeCount++);
      QNode node4 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 100, "n" + Network.nodeCount++);
      QEdge edge1 = new QEdge("e" + Network.edgeCount++);
      edge1.setSource(node1);
      edge1.setTarget(node2);
      node1.addEdge(edge1);
      node2.addEdge(edge1);
      QEdge edge2 = new QEdge("e" + Network.edgeCount++);
      edge2.setSource(node1);
      edge2.setTarget(node3);
      node1.addEdge(edge2);
      node3.addEdge(edge2);
      QEdge edge3 = new QEdge("e" + Network.edgeCount++);
      edge3.setSource(node2);
      edge3.setTarget(node4);
      node2.addEdge(edge3);
      node4.addEdge(edge3);
      QEdge edge4 = new QEdge("e" + Network.edgeCount++);
      edge4.setSource(node3);
      edge4.setTarget(node4);
      node3.addEdge(edge4);
      node4.addEdge(edge4);
      node1.addToLayer(nodeLayer);
      node2.addToLayer(nodeLayer);
      node3.addToLayer(nodeLayer);
      node4.addToLayer(nodeLayer);
      edgeLayer.addChild(edge1);
      edgeLayer.addChild(edge2);
      edgeLayer.addChild(edge3);
      edgeLayer.addChild(edge4);
      edge1.update();
      edge2.update();
      edge3.update();
      edge4.update();
      Network.nCount += 4;
      Network.eCount += 4;
      frame.updateStatus();
      break;
    }
    }
    frame.isModif = true;
    frame.setTitleModif();
  }
}