package netmatch.wizard;

import netmatch.algorithm.Common;
import netmatch.netMatchPanel;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

public class WizardForm extends JFrame implements WindowListener {
  private javax.swing.JButton backButton;
  private javax.swing.JPanel containerPanel;
  private javax.swing.JButton nextButton;
  private javax.swing.JLabel step1Label;
  private javax.swing.JLabel step2Label;
  private javax.swing.JLabel step3Label;
  private javax.swing.JLabel step4Label;
  private javax.swing.JLabel step5Label;
  private int step = 1;
  WizardPanel1 wp1;
  public WizardPanel2 wp2;
  WizardPanel3 wp3;
  WizardPanel4 wp4;
  WizardPanel5 wp5;
  Font fontn, fontb;
  netMatchPanel netPanel;

  public WizardForm(netMatchPanel netMatchPanel) {
    netPanel = netMatchPanel;
    setTitle("NetMatch V" + Common.VERSION_NUMBER + " Wizard - Step 1");
    setIconImage(netPanel.menu[15].getImage());
    initComponents();
    wp1 = new WizardPanel1();
    wp2 = new WizardPanel2(netPanel);
    wp3 = new WizardPanel3(netPanel);
    wp4 = new WizardPanel4(wp3);
    wp5 = new WizardPanel5();
    fontb = new java.awt.Font("Tahoma", Font.BOLD, 11);
    fontn = new java.awt.Font("Tahoma", Font.PLAIN, 11);
    containerPanel.add(wp1);
    backButton.setEnabled(false);
    step1Label.setFont(fontb);
    step2Label.setFont(fontn);
    step3Label.setFont(fontn);
    step4Label.setFont(fontn);
    addWindowListener(this);
  }

  public void acquire() {
    wp1.acquireTargets();
    wp2.acquireAttr();
    wp3.acquireQueries();
    wp4.acquireAttr();
  }

  private void initComponents() {
    JPanel jPanel1 = new JPanel();
    nextButton = new javax.swing.JButton();
    backButton = new javax.swing.JButton();
    JButton classicButton = new JButton();
    JPanel stepsPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    step1Label = new javax.swing.JLabel();
    step2Label = new javax.swing.JLabel();
    step3Label = new javax.swing.JLabel();
    step4Label = new javax.swing.JLabel();
    step5Label = new javax.swing.JLabel();
    JSeparator jSeparator1 = new JSeparator();
    containerPanel = new javax.swing.JPanel();
    JSeparator jSeparator2 = new JSeparator();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    jPanel1.setName("buttonPanel");
    nextButton.setText("Next");
    nextButton.setAlignmentY(0.0F);
    nextButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        nextButtonActionPerformed(evt);
      }
    });

    backButton.setText("Back");
    backButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        backButtonActionPerformed(evt);
      }
    });

    classicButton.setText("Swith To Classic Mode");
    classicButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        classicButtonActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
            .addContainerGap()
            .add(classicButton)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 250, Short.MAX_VALUE)
            .add(backButton)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(nextButton)
            .add(21, 21, 21)));
    jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
            .add(nextButton)
            .add(backButton)
            .add(classicButton)));

    stepsPanel.setBackground(new java.awt.Color(153, 153, 255));
    stepsPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
    stepsPanel.setName("stepPanel");
    jLabel1.setText("Steps:");

    step1Label.setText("1. Select target network");

    step2Label.setText("2. Select target attributes");

    step3Label.setText("3. Select query network");
    step4Label.setText("4. Select query attributes");

    step5Label.setText("5. Select matching properities");

    org.jdesktop.layout.GroupLayout stepsPanelLayout = new org.jdesktop.layout.GroupLayout(stepsPanel);
    stepsPanel.setLayout(stepsPanelLayout);
    stepsPanelLayout.setHorizontalGroup(stepsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(stepsPanelLayout.createSequentialGroup()
            .addContainerGap()
            .add(stepsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                    .add(jLabel1)
                    .add(step1Label)
                    .add(step2Label)
                    .add(step3Label)
                    .add(step4Label)
                    .add(step5Label, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addContainerGap()));
    stepsPanelLayout.setVerticalGroup(stepsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(stepsPanelLayout.createSequentialGroup()
            .addContainerGap()
            .add(jLabel1)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(step1Label)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(step2Label)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(step3Label)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(step4Label)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(step5Label)
            .addContainerGap(165, Short.MAX_VALUE)));

    containerPanel.setLayout(new javax.swing.BoxLayout(containerPanel, javax.swing.BoxLayout.X_AXIS));

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                    .add(stepsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(containerPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 390, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                    .addContainerGap()
                    .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 540, Short.MAX_VALUE)
                    .addContainerGap())
            .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addContainerGap()));
    layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(containerPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, stepsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .add(12, 12, 12)
            .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addContainerGap()));
    pack();
  }

  private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {
    switch(step) {
    case 1:
      if(!wp1.validateAndSave())
        return;
      containerPanel.remove(wp1);
      step1Label.setFont(fontn);
      wp2.acquireAttr();
      containerPanel.add(wp2);
      step2Label.setFont(fontb);
      backButton.setEnabled(true);
      break;
    case 2:
      if(!wp2.validateAndSave())
        return;
      containerPanel.remove(wp2);
      step2Label.setFont(fontn);
      wp3.acquireQueries();
      containerPanel.add(wp3);
      step3Label.setFont(fontb);
      break;
    case 3:
      if(!wp3.validateAndSave())
        return;
      containerPanel.remove(wp3);
      step3Label.setFont(fontn);
      wp4.acquireAttr();
      containerPanel.add(wp4);
      step4Label.setFont(fontb);
      break;
    case 4:
      if(!wp4.validateAndSave())
        return;
      containerPanel.remove(wp4);
      step4Label.setFont(fontn);
      containerPanel.add(wp5);
      step5Label.setFont(fontb);
      nextButton.setText("Go!");
      break;
    case 5:
      if(!wp5.validateAndSave())
        return;
      this.setVisible(false);
      netPanel.setDataFromWizard(wp1.getValue(), wp3.getValue(), wp2.getNodeValue(), wp2.getEdgeValue(), wp4.getNodeValue(), wp4.getEdgeValue(), wp5.getLabeledValue(), wp5.getDirectedValue());
      netPanel.actionPerformed(new ActionEvent(this,0,"Go"));
      netPanel.setVisible(true);
      break;
    }
    step++;
    setTitle("NetMatch V" + Common.VERSION_NUMBER + " Wizard - Step " + step);
  }

  public void init() {
    containerPanel.removeAll();
    containerPanel.add(wp1);
    step1Label.setFont(fontb);
    backButton.setEnabled(false);
    step2Label.setFont(fontn);
    step3Label.setFont(fontn);
    step4Label.setFont(fontn);
    step5Label.setFont(fontn);
    nextButton.setText("Next");
    step = 1;
  }

  public void editorDone(String queryName) {
    wp3.acquireQueries();
    wp3.selectQuery(queryName);
  }

  private void backButtonActionPerformed(java.awt.event.ActionEvent evt) {
    switch(step) {
    case 2:
      containerPanel.remove(wp2);
      step2Label.setFont(fontn);
      containerPanel.add(wp1);
      step1Label.setFont(fontb);
      backButton.setEnabled(false);
      break;
    case 3:
      containerPanel.remove(wp3);
      step3Label.setFont(fontn);
      containerPanel.add(wp2);
      step2Label.setFont(fontb);
      break;
    case 4:
      containerPanel.remove(wp4);
      step4Label.setFont(fontn);
      containerPanel.add(wp3);
      step3Label.setFont(fontb);
      break;
    case 5:
      containerPanel.remove(wp5);
      step5Label.setFont(fontn);
      containerPanel.add(wp4);
      step4Label.setFont(fontb);
      nextButton.setText("Next");
      break;
    }
    step--;
    setTitle("NetMatch V" + Common.VERSION_NUMBER + " Wizard - Step " + step);
  }

  private void classicButtonActionPerformed(java.awt.event.ActionEvent evt) {
    netPanel.setDataFromWizard(wp1.getValue(), wp3.getValue(), wp2.getNodeValue(), wp2.getEdgeValue(), wp4.getNodeValue(), wp4.getEdgeValue(), wp5.getLabeledValue(), wp5.getDirectedValue());
    this.setVisible(false);
    netPanel.setVisible(true);
  }

  public void windowActivated(WindowEvent e) {
  }

  public void windowClosed(WindowEvent e) {
  }

  public void windowClosing(WindowEvent e) {
    netPanel.setDataFromWizard(wp1.getValue(), wp3.getValue(), wp2.getNodeValue(), wp2.getEdgeValue(), wp4.getNodeValue(), wp4.getEdgeValue(), wp5.getLabeledValue(), wp5.getDirectedValue());
    this.setVisible(false);
    netPanel.setVisible(true);
  }

  public void windowDeactivated(WindowEvent e) {
  }

  public void windowDeiconified(WindowEvent e) {
  }

  public void windowIconified(WindowEvent e) {
  }

  public void windowOpened(WindowEvent e) {
  }
}
